/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.synergy.impl;

import hudson.plugins.synergy.impl.Command;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.StringReader;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FindUseCommand
extends Command {
    private String object;
    private Set<String> projects;
    private String delimiter;
    private String path;

    public FindUseCommand(String object, Set<String> projects, String delimiter) {
        this.object = object;
        this.projects = projects;
        this.delimiter = delimiter;
    }

    @Override
    public String[] buildCommand(String ccmExe) {
        String[] commands = new String[]{ccmExe, "finduse", this.object};
        return commands;
    }

    @Override
    public void parseResult(String result) {
        BufferedReader reader = new BufferedReader(new StringReader(result));
        try {
            String line = reader.readLine();
            while (line != null) {
                String usingProject;
                int projectIndex = line.indexOf(64);
                if (projectIndex != -1 && this.projects.contains(usingProject = line.substring(projectIndex + 1))) {
                    this.path = line.substring(0, line.indexOf(this.delimiter)).trim();
                    break;
                }
                line = reader.readLine();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public String getPath() {
        return this.path;
    }
}

