/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.synergy.impl;

import hudson.plugins.synergy.impl.Command;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GetProjectInBaselineCommand
extends Command {
    private String baseline;
    private List<String> projects = new ArrayList<String>();

    public GetProjectInBaselineCommand(String baselineObjectName) {
        this.baseline = baselineObjectName;
    }

    @Override
    public String[] buildCommand(String ccmExe) {
        String[] commands = new String[]{ccmExe, "query", "-u", "-f", "%objectname", "is_project_in_baseline_of('" + this.baseline + "')"};
        return commands;
    }

    @Override
    public void parseResult(String result) {
        BufferedReader reader = new BufferedReader(new StringReader(result));
        try {
            String line = reader.readLine();
            while (line != null) {
                this.projects.add(line);
                line = reader.readLine();
            }
        }
        catch (IOException e) {
            // empty catch block
        }
    }

    public List<String> getProjects() {
        return this.projects;
    }
}

