/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.synergy.impl;

import hudson.plugins.synergy.impl.Command;
import java.util.Arrays;
import java.util.List;

public class StartCommand
extends Command {
    private String ccmAddr;
    private String login;
    private String database;
    private String engine;
    private String password;
    private boolean remoteClient;

    public StartCommand(String database, String engine, String login, String password, boolean remoteClient) {
        this.database = database;
        this.engine = engine;
        this.login = login;
        this.password = password;
        this.remoteClient = remoteClient;
    }

    public String[] buildCommand(String ccmAddr) {
        String[] commands = new String[]{ccmAddr, "start", "-d", this.database, "-h", this.engine, "-n", this.login, "-nogui", "-m", "-q", "-pw", this.password};
        if (this.remoteClient) {
            List<String> list = Arrays.asList(commands);
            list.add("-rc");
            commands = list.toArray(new String[list.size()]);
        }
        return commands;
    }

    public boolean[] buildMask() {
        boolean[] result = super.buildMask();
        int pwdIndex = 12;
        result[pwdIndex] = true;
        return result;
    }

    public void parseResult(String result) {
        this.ccmAddr = result;
    }

    public String getCcmAddr() {
        return this.ccmAddr;
    }

    public boolean isStatusOK(int status) {
        return status == 0;
    }
}

