/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.synergy.impl;

import hudson.plugins.synergy.impl.Command;
import hudson.plugins.synergy.impl.Conflict;
import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ProjectConflicts
extends Command {
    private String project;
    private List<Conflict> conflicts = new ArrayList<Conflict>();

    public ProjectConflicts(String project) {
        this.project = project;
    }

    @Override
    public String[] buildCommand(String ccmExe) {
        return new String[]{ccmExe, "conflicts", "-t", "-r", "-noformat", this.project};
    }

    @Override
    public void parseResult(String line) {
        if ((line = line.trim()).length() == 0) {
            return;
        }
        if (line.startsWith("Project")) {
            return;
        }
        if (line.indexOf("No conflicts detected") != -1) {
            return;
        }
        StringTokenizer tokenizer = new StringTokenizer(line, "\t");
        String objectname = tokenizer.nextToken();
        String task = tokenizer.nextToken();
        String message = tokenizer.nextToken();
        int index = message.lastIndexOf("-");
        String type = message.substring(index + 1).trim();
        Conflict conflict = new Conflict(objectname, task, type, message);
        this.conflicts.add(conflict);
    }

    public List<Conflict> getConflicts() {
        return this.conflicts;
    }
}

