/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.synergy;

import hudson.FilePath;
import hudson.Launcher;
import hudson.model.AbstractBuild;
import hudson.model.AbstractProject;
import hudson.model.BuildListener;
import hudson.model.Descriptor;
import hudson.model.TaskListener;
import hudson.plugins.synergy.SynergyChangeLogParser;
import hudson.plugins.synergy.SynergyChangeLogSet;
import hudson.plugins.synergy.impl.CheckoutResult;
import hudson.plugins.synergy.impl.Commands;
import hudson.plugins.synergy.impl.CompareProjectCommand;
import hudson.plugins.synergy.impl.Conflict;
import hudson.plugins.synergy.impl.FindAssociatedTaskCommand;
import hudson.plugins.synergy.impl.FindCompletedSinceDateCommand;
import hudson.plugins.synergy.impl.FindUseCommand;
import hudson.plugins.synergy.impl.GetDelimiterCommand;
import hudson.plugins.synergy.impl.GetProjectAttributeCommand;
import hudson.plugins.synergy.impl.GetProjectInBaselineCommand;
import hudson.plugins.synergy.impl.GetProjectStateCommand;
import hudson.plugins.synergy.impl.ProjectConflicts;
import hudson.plugins.synergy.impl.SetProjectAttributeCommand;
import hudson.plugins.synergy.impl.SetRoleCommand;
import hudson.plugins.synergy.impl.StartCommand;
import hudson.plugins.synergy.impl.StopCommand;
import hudson.plugins.synergy.impl.SubProjectQueryCommand;
import hudson.plugins.synergy.impl.SynergyException;
import hudson.plugins.synergy.impl.TaskCompleted;
import hudson.plugins.synergy.impl.TaskInfoCommand;
import hudson.plugins.synergy.impl.UpdateCommand;
import hudson.plugins.synergy.impl.WorkareaSnapshotCommand;
import hudson.plugins.synergy.impl.WriteObjectCommand;
import hudson.scm.ChangeLogParser;
import hudson.scm.SCM;
import hudson.scm.SCMDescriptor;
import hudson.util.FormFieldValidator;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Serializable;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import javax.servlet.ServletException;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.StaplerRequest;
import org.kohsuke.stapler.StaplerResponse;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SynergySCM
extends SCM
implements Serializable {
    private String project;
    private String database;
    private String release;
    private String purpose;
    private String engine;
    private String username;
    private String password;
    private String oldProject;
    private String baseline;
    private String oldBaseline;
    private boolean remoteClient;
    private boolean detectConflict;
    private transient Commands commands;

    @DataBoundConstructor
    public SynergySCM(String project, String database, String release, String purpose, String username, String password, String engine, String oldProject, String baseline, String oldBaseline, boolean remoteClient, boolean detectConflict) {
        this.project = project;
        this.database = database;
        this.release = release;
        this.purpose = purpose;
        this.username = username;
        this.password = password;
        this.engine = engine;
        this.oldProject = oldProject;
        this.baseline = baseline;
        this.oldBaseline = oldBaseline;
        this.remoteClient = remoteClient;
        this.detectConflict = detectConflict;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean checkout(AbstractBuild build, Launcher launcher, FilePath path, BuildListener listener, File changeLogFile) throws IOException, InterruptedException {
        block20: {
            this.commands = new Commands();
            this.commands.setCcmExe(this.getDescriptor().getCcmExe());
            this.commands.setCcmUiLog(this.getDescriptor().getCcmUiLog());
            this.commands.setCcmEngLog(this.getDescriptor().getCcmEngLog());
            this.commands.setTaskListener((TaskListener)listener);
            this.commands.setLauncher(launcher);
            try {
                StartCommand command = new StartCommand(this.database, this.engine, this.username, this.password, this.remoteClient);
                this.commands.executeSynergyCommand(path, command);
                String ccmAddr = command.getCcmAddr();
                this.commands.setCcmAddr(ccmAddr);
                String projectName = this.computeDynamicValue(build, this.project);
                String oldProjectName = this.computeDynamicValue(build, this.oldProject);
                String baselineName = this.computeDynamicValue(build, this.baseline);
                String oldBaselineName = this.computeDynamicValue(build, this.oldBaseline);
                SetRoleCommand setRoleCommand = new SetRoleCommand("build_mgr");
                this.commands.executeSynergyCommand(path, setRoleCommand);
                if (this.project != null && this.project.length() != 0) {
                    CheckoutResult result = this.checkoutProject(path, changeLogFile, projectName, oldProjectName);
                    if (result != null) {
                        this.writeChangeLog(changeLogFile, result.getLogs());
                        if (result.getConflicts() != null && !result.getConflicts().isEmpty()) {
                            listener.getLogger().println("Error : conflicts detected for project " + projectName);
                            boolean bl = false;
                            return bl;
                        }
                    }
                    break block20;
                }
                if (this.baseline != null && this.baseline.length() != 0) {
                    this.checkoutBaseline(path, changeLogFile, baselineName, oldBaselineName);
                    break block20;
                }
                listener.getLogger().println("Error : neither project nor baseline is specified");
                boolean bl = false;
                return bl;
            }
            catch (SynergyException e) {
                boolean bl = false;
                return bl;
            }
            finally {
                StopCommand stopCommand = new StopCommand();
                try {
                    this.commands.executeSynergyCommand(path, stopCommand);
                }
                catch (SynergyException e) {
                    return false;
                }
            }
        }
        return true;
    }

    private void checkoutBaseline(FilePath path, File changeLogFile, String baselineName, String oldBaselineName) throws IOException, InterruptedException, SynergyException {
        GetDelimiterCommand getDelim = new GetDelimiterCommand();
        this.commands.executeSynergyCommand(path, getDelim);
        String delim = getDelim.getDelimiter();
        String baselineObjectName = baselineName;
        if (baselineObjectName.indexOf(":baseline:") == -1) {
            baselineObjectName = baselineName + delim + "1:baseline:1";
        }
        GetProjectInBaselineCommand projectsCommand = new GetProjectInBaselineCommand(baselineObjectName);
        this.commands.executeSynergyCommand(path, projectsCommand);
        List<String> projects = projectsCommand.getProjects();
        HashMap<String, String> projectsMapping = new HashMap<String, String>();
        for (String newProject : projects) {
            String newProjectName = newProject.substring(0, newProject.indexOf(58));
            projectsMapping.put(newProjectName, null);
        }
        if (oldBaselineName != null && oldBaselineName.length() != 0) {
            String oldBaselineObjectName = oldBaselineName;
            if (oldBaselineObjectName.indexOf(":baseline:") == -1) {
                oldBaselineObjectName = oldBaselineName + delim + "1:baseline:1";
            }
            projectsCommand = new GetProjectInBaselineCommand(oldBaselineObjectName);
            this.commands.executeSynergyCommand(path, projectsCommand);
            List<String> oldProjects = projectsCommand.getProjects();
            HashMap<String, String> projectNames = new HashMap<String, String>();
            for (String oldProject : oldProjects) {
                String projectNameWithoutVersion = oldProject.substring(0, oldProject.indexOf(delim));
                String oldProjectNameWithVersion = oldProject.substring(0, oldProject.indexOf(58));
                projectNames.put(projectNameWithoutVersion, oldProjectNameWithVersion);
            }
            for (String newProject : projects) {
                String newProjectNameWithoutVersion = newProject.substring(0, newProject.indexOf(delim));
                String newProjectNameWithVersion = newProject.substring(0, newProject.indexOf(58));
                String oldProjectNameWithVersion = (String)projectNames.get(newProjectNameWithoutVersion);
                projectsMapping.put(newProjectNameWithVersion, oldProjectNameWithVersion);
            }
        }
        path.deleteContents();
        ArrayList<SynergyChangeLogSet.LogEntry> allEntries = new ArrayList<SynergyChangeLogSet.LogEntry>();
        for (Map.Entry project : projectsMapping.entrySet()) {
            CheckoutResult result = this.checkoutStaticProject(path, changeLogFile, (String)project.getKey(), (String)project.getValue());
            Collection<SynergyChangeLogSet.LogEntry> entries = result.getLogs();
            allEntries.addAll(entries);
        }
        this.writeChangeLog(changeLogFile, allEntries);
    }

    private CheckoutResult checkoutStaticProject(FilePath path, File changeLogFile, String projectName, String oldProjectName) throws IOException, InterruptedException, SynergyException {
        String desiredWorkArea = this.getCleanWorkareaPath(path);
        if (oldProjectName != null && oldProjectName.length() != 0) {
            CompareProjectCommand compareCommand = new CompareProjectCommand(projectName, oldProjectName);
            this.commands.executeSynergyCommand(path, compareCommand);
            List<String> result = compareCommand.getDifferences();
            Collection<SynergyChangeLogSet.LogEntry> entries = this.generateChangeLog(result, projectName, changeLogFile, path);
            this.copyEntries(path, entries);
            return new CheckoutResult(null, entries);
        }
        WorkareaSnapshotCommand workareaSnapshotCommand = new WorkareaSnapshotCommand(projectName, desiredWorkArea);
        this.commands.executeSynergyCommand(path, workareaSnapshotCommand);
        return null;
    }

    private CheckoutResult checkoutProject(FilePath path, File changeLogFile, String projectName, String oldProjectName) throws IOException, InterruptedException, SynergyException {
        if (this.isStaticProject(projectName, path)) {
            path.deleteContents();
            return this.checkoutStaticProject(path, changeLogFile, projectName, oldProjectName);
        }
        return this.checkoutDynamicProject(path, changeLogFile, projectName);
    }

    private CheckoutResult checkoutDynamicProject(FilePath path, File changeLogFile, String projectName) throws IOException, InterruptedException, SynergyException {
        this.setAbsoluteWorkarea(path);
        UpdateCommand updateCommand = new UpdateCommand(projectName);
        this.commands.executeSynergyCommand(path, updateCommand);
        List<String> updates = updateCommand.getUpdates();
        Collection<SynergyChangeLogSet.LogEntry> logs = this.generateChangeLog(updates, projectName, changeLogFile, path);
        List<Conflict> conflicts = null;
        if (this.detectConflict) {
            ProjectConflicts conflictsCommand = new ProjectConflicts(projectName);
            this.commands.executeSynergyCommand(path, conflictsCommand);
            conflicts = conflictsCommand.getConflicts();
        }
        return new CheckoutResult(conflicts, logs);
    }

    private void copyEntries(FilePath path, Collection<SynergyChangeLogSet.LogEntry> entries) throws IOException, InterruptedException, SynergyException {
        for (SynergyChangeLogSet.LogEntry entry : entries) {
            for (SynergyChangeLogSet.Path object : entry.getPaths()) {
                String id = object.getId();
                if (id.indexOf(":dir:") != -1) continue;
                String pathInProject = object.getValue();
                FilePath pathInWorkarea = path.child(pathInProject);
                WriteObjectCommand command = new WriteObjectCommand(id, pathInWorkarea);
                this.commands.executeSynergyCommand(path, command);
            }
        }
    }

    private String getCleanWorkareaPath(FilePath path) {
        String desiredWorkArea = path.getRemote();
        desiredWorkArea = desiredWorkArea.replace("\\.\\", "\\");
        return desiredWorkArea;
    }

    private String computeDynamicValue(AbstractBuild build, String parameterizedValue) throws IllegalStateException {
        if (parameterizedValue != null && parameterizedValue.indexOf("${") != -1) {
            int start = parameterizedValue.indexOf("${");
            int end = parameterizedValue.indexOf("}", start);
            String parameter = parameterizedValue.substring(start + 2, end);
            String value = (String)build.getEnvVars().get(parameter);
            if (value == null) {
                throw new IllegalStateException(parameter);
            }
            return parameterizedValue.substring(0, start) + value + (parameterizedValue.length() > end + 1 ? parameterizedValue.substring(end + 1) : "");
        }
        return parameterizedValue;
    }

    private boolean isStaticProject(String project, FilePath workspace) throws IOException, InterruptedException, SynergyException {
        GetProjectStateCommand command = new GetProjectStateCommand(project);
        this.commands.executeSynergyCommand(workspace, command);
        String state = command.getState();
        return !"prep".equals(state) && !"working".equals(state);
    }

    private void configureWorkarea(String project, boolean relative, FilePath workspace, FilePath workarea) throws IOException, InterruptedException, SynergyException {
        GetProjectAttributeCommand getProjectAttributeCommand = new GetProjectAttributeCommand(project, "maintain_wa");
        this.commands.executeSynergyCommand(workspace, getProjectAttributeCommand);
        String maintainWorkArea = getProjectAttributeCommand.getValue();
        boolean changeMaintain = false;
        if (!"TRUE".equals(maintainWorkArea)) {
            SetProjectAttributeCommand setProjectAttributeCommand = new SetProjectAttributeCommand(project, "maintain_wa", "TRUE");
            this.commands.executeSynergyCommand(workspace, setProjectAttributeCommand);
            changeMaintain = true;
        }
        if (relative) {
            getProjectAttributeCommand = new GetProjectAttributeCommand(project, "is_relative");
            this.commands.executeSynergyCommand(workspace, getProjectAttributeCommand);
            String relativeWorkArea = getProjectAttributeCommand.getValue();
            if (relative && !"TRUE".equals(relativeWorkArea)) {
                SetProjectAttributeCommand setProjectAttributeCommand = new SetProjectAttributeCommand(project, "is_relative", relative ? "TRUE" : "FALSE");
                this.commands.executeSynergyCommand(workspace, setProjectAttributeCommand);
            }
        }
        getProjectAttributeCommand = new GetProjectAttributeCommand(project, "wa_path");
        this.commands.executeSynergyCommand(workspace, getProjectAttributeCommand);
        String currentWorkArea = getProjectAttributeCommand.getValue();
        String desiredWorkArea = this.getCleanWorkareaPath(workarea);
        if (!currentWorkArea.equals(desiredWorkArea) || changeMaintain) {
            SetProjectAttributeCommand setProjectAttributeCommand = new SetProjectAttributeCommand(project, "wa_path", desiredWorkArea);
            this.commands.executeSynergyCommand(workspace, setProjectAttributeCommand);
        }
    }

    private void setAbsoluteWorkarea(FilePath path) throws IOException, InterruptedException, SynergyException {
        SubProjectQueryCommand command;
        block4: {
            this.configureWorkarea(this.project, false, path, path);
            command = new SubProjectQueryCommand(this.project);
            try {
                this.commands.executeSynergyCommand(path, command);
            }
            catch (SynergyException e) {
                if (e.getStatus() == 1) break block4;
                throw e;
            }
        }
        List<String> subProjects = command.getSubProjects();
        if (subProjects != null && subProjects.size() > 0) {
            GetDelimiterCommand getDelim = new GetDelimiterCommand();
            this.commands.executeSynergyCommand(path, getDelim);
            String delimiter = getDelim.getDelimiter();
            String projetPrincipal = this.project.split(delimiter)[0];
            for (String subProject : subProjects) {
                this.configureWorkarea(subProject, true, path, new FilePath(path, projetPrincipal));
            }
        }
    }

    public static File getRevisionFile(AbstractBuild build) {
        return new File(build.getRootDir(), "revision.txt");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static Map<String, Long> parseRevisionFile(AbstractBuild build) throws IOException {
        HashMap<String, Long> revisions;
        block8: {
            revisions = new HashMap<String, Long>();
            File file = SynergySCM.getRevisionFile(build);
            if (!file.exists()) {
                return revisions;
            }
            BufferedReader br = new BufferedReader(new FileReader(file));
            block5: while (true) {
                String line;
                while ((line = br.readLine()) != null) {
                    int index = line.lastIndexOf(47);
                    if (index < 0) continue;
                    try {
                        revisions.put(line.substring(0, index), Long.parseLong(line.substring(index + 1)));
                        continue block5;
                    }
                    catch (NumberFormatException e) {
                    }
                }
                break block8;
                {
                    continue block5;
                    break;
                }
                break;
            }
            finally {
                br.close();
            }
        }
        return revisions;
    }

    private Collection<SynergyChangeLogSet.LogEntry> generateChangeLog(List<String> names, String projectName, File changeLogFile, FilePath workarea) throws IOException, InterruptedException, SynergyException {
        HashMap<String, SynergyChangeLogSet.LogEntry> logs = new HashMap<String, SynergyChangeLogSet.LogEntry>();
        DateFormat dateFormat = DateFormat.getDateTimeInstance();
        if (names != null) {
            SubProjectQueryCommand subProjectQuery = new SubProjectQueryCommand(projectName);
            this.commands.executeSynergyCommand(workarea, subProjectQuery);
            HashSet<String> projects = new HashSet<String>(subProjectQuery.getSubProjects());
            projects.add(projectName);
            GetDelimiterCommand getDelim = new GetDelimiterCommand();
            this.commands.executeSynergyCommand(workarea, getDelim);
            String delimiter = getDelim.getDelimiter();
            HashMap<String, String> subProjectsUse = new HashMap<String, String>();
            if (projects.size() > 1) {
                HashSet<String> set = new HashSet<String>();
                set.add(projectName);
                for (String project : projects) {
                    if (project.equals(projectName)) continue;
                    FindUseCommand findUse = new FindUseCommand(project, set, delimiter);
                    this.commands.executeSynergyCommand(workarea, findUse);
                    String use = findUse.getPath();
                    if (use == null) continue;
                    subProjectsUse.put(project, use);
                }
            }
            for (String name : names) {
                String taskId;
                SynergyChangeLogSet.LogEntry entry = null;
                FindAssociatedTaskCommand taskCommand = new FindAssociatedTaskCommand(name);
                this.commands.executeSynergyCommand(workarea, taskCommand);
                List<String> taskIds = taskCommand.getTasks();
                if (taskIds != null && !taskIds.isEmpty() && (entry = (SynergyChangeLogSet.LogEntry)((Object)logs.get(taskId = taskIds.get(0)))) == null) {
                    entry = new SynergyChangeLogSet.LogEntry();
                    ArrayList<String> t = new ArrayList<String>(1);
                    t.add(taskId);
                    TaskInfoCommand taskInfoCommand = new TaskInfoCommand(t);
                    this.commands.executeSynergyCommand(workarea, taskInfoCommand);
                    List<TaskCompleted> infos = taskInfoCommand.getInformations();
                    if (!infos.isEmpty()) {
                        entry.setMsg(infos.get(0).getSynopsis());
                        entry.setUser(infos.get(0).getResolver());
                        entry.setTaskId(infos.get(0).getId());
                        entry.setDate(infos.get(0).getDateCompleted() == null ? null : dateFormat.format(infos.get(0).getDateCompleted()));
                    }
                    logs.put(taskId, entry);
                }
                if (entry == null && (entry = (SynergyChangeLogSet.LogEntry)((Object)logs.get(null))) == null) {
                    entry = new SynergyChangeLogSet.LogEntry();
                    entry.setMsg("Unknown task");
                    logs.put(null, entry);
                }
                FindUseCommand command = new FindUseCommand(name, projects, delimiter);
                this.commands.executeSynergyCommand(workarea, command);
                String pathInProject = command.getPath();
                if (pathInProject == null) continue;
                if (!pathInProject.startsWith(projectName)) {
                    // empty if block
                }
                SynergyChangeLogSet.Path path = new SynergyChangeLogSet.Path();
                path.setId(name);
                path.setValue(pathInProject);
                entry.addPath(path);
            }
        }
        return logs.values();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeChangeLog(File changeLogFile, Collection<SynergyChangeLogSet.LogEntry> logs) {
        if (logs != null) {
            PrintWriter writer = null;
            try {
                writer = new PrintWriter(changeLogFile, "UTF-8");
                writer.println("<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
                writer.println("<log>");
                for (SynergyChangeLogSet.LogEntry log : logs) {
                    writer.println(String.format("\t<logentry revision=\"%s\">", log.getTaskId()));
                    writer.println(String.format("\t\t<task>%s</task>", log.getTaskId()));
                    writer.println(String.format("\t\t<author>%s</author>", log.getUser()));
                    writer.println(String.format("\t\t<date>%s</date>", log.getDate()));
                    writer.println(String.format("\t\t<msg><![CDATA[%s]]></msg>", log.getMsg()));
                    writer.println("\t\t<paths>");
                    for (SynergyChangeLogSet.Path path : log.getPaths()) {
                        writer.println(String.format("\t\t\t<path action=\"%s\">%s</path>", path.getEditType(), path.getValue()));
                    }
                    writer.println("\t\t</paths>");
                    writer.println("\t</logentry>");
                }
                writer.println("</log>");
            }
            catch (IOException e) {
            }
            finally {
                if (writer != null) {
                    writer.close();
                }
            }
        }
    }

    public ChangeLogParser createChangeLogParser() {
        return new SynergyChangeLogParser();
    }

    public DescriptorImpl getDescriptor() {
        return DescriptorImpl.DESCRIPTOR;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean pollChanges(AbstractProject project, Launcher launcher, FilePath path, TaskListener listener) throws IOException, InterruptedException {
        AbstractBuild lastBuild = (AbstractBuild)project.getLastBuild();
        if (this.release == null) {
            listener.getLogger().println("The release attribute is not set. It is required for change pooling.");
            return false;
        }
        if (lastBuild == null) {
            listener.getLogger().println("No existing build. Starting a new one");
            return true;
        }
        Calendar date = lastBuild.getTimestamp();
        this.commands = new Commands();
        this.commands.setCcmExe(this.getDescriptor().getCcmExe());
        this.commands.setCcmUiLog(this.getDescriptor().getCcmUiLog());
        this.commands.setCcmEngLog(this.getDescriptor().getCcmEngLog());
        this.commands.setTaskListener(listener);
        this.commands.setLauncher(launcher);
        try {
            StartCommand command = new StartCommand(this.database, this.engine, this.username, this.password, this.remoteClient);
            this.commands.executeSynergyCommand(path, command);
            String ccmAddr = command.getCcmAddr();
            this.commands.setCcmAddr(ccmAddr);
            FindCompletedSinceDateCommand findCommand = new FindCompletedSinceDateCommand(date, this.release);
            this.commands.executeSynergyCommand(path, findCommand);
            List<String> result = findCommand.getTasks();
            boolean bl = result != null && !result.isEmpty();
            return bl;
        }
        catch (SynergyException e) {
            boolean bl = false;
            return bl;
        }
        finally {
            StopCommand stopCommand = new StopCommand();
            try {
                this.commands.executeSynergyCommand(path, stopCommand);
            }
            catch (SynergyException e) {
                return false;
            }
        }
    }

    public String getProject() {
        return this.project;
    }

    public String getDatabase() {
        return this.database;
    }

    public String getUsername() {
        return this.username;
    }

    public String getPassword() {
        return this.password;
    }

    public String getRelease() {
        return this.release;
    }

    public String getPurpose() {
        return this.purpose;
    }

    public String getEngine() {
        return this.engine;
    }

    public void setEngine(String engine) {
        this.engine = engine;
    }

    public String getOldProject() {
        return this.oldProject;
    }

    public String getBaseline() {
        return this.baseline;
    }

    public String getOldBaseline() {
        return this.oldBaseline;
    }

    public boolean isRemoteClient() {
        return this.remoteClient;
    }

    public void setRemoteClient(boolean remoteClient) {
        this.remoteClient = remoteClient;
    }

    public boolean isDetectConflict() {
        return this.detectConflict;
    }

    public void setDetectConflict(boolean detectConflict) {
        this.detectConflict = detectConflict;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class DescriptorImpl
    extends SCMDescriptor<SynergySCM> {
        public static final DescriptorImpl DESCRIPTOR = new DescriptorImpl();
        private String ccmExe;
        private String ccmUiLog;
        private String ccmEngLog;

        public String getCcmEngLog() {
            return this.ccmEngLog;
        }

        public String getCcmUiLog() {
            return this.ccmUiLog;
        }

        private DescriptorImpl() {
            super(SynergySCM.class, null);
            this.load();
        }

        public boolean configure(StaplerRequest request) throws Descriptor.FormException {
            this.ccmExe = request.getParameter("synergy.ccmExe");
            this.ccmUiLog = request.getParameter("synergy.ccmUiLog");
            this.ccmEngLog = request.getParameter("synergy.ccmEngLog");
            this.save();
            return true;
        }

        public SCM newInstance(StaplerRequest req) throws Descriptor.FormException {
            return new SynergySCM(req.getParameter("synergy.project"), req.getParameter("synergy.database"), req.getParameter("synergy.release"), req.getParameter("synergy.purpose"), req.getParameter("synergy.username"), req.getParameter("synergy.password"), req.getParameter("synergy.engine"), req.getParameter("synergy.oldProject"), req.getParameter("synergy.baseline"), req.getParameter("synergy.oldBaseline"), "true".equals(req.getParameter("synergy.remoteClient")), "true".equals(req.getParameter("synergy.detectConflict")));
        }

        public void doCcmExeCheck(StaplerRequest req, StaplerResponse rsp) throws IOException, ServletException {
            new FormFieldValidator.Executable(req, rsp).process();
        }

        public String getDisplayName() {
            return "Synergy";
        }

        public String getCcmExe() {
            if (this.ccmExe == null) {
                return "ccm";
            }
            return this.ccmExe;
        }
    }
}

