/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.synergy.impl;

import hudson.plugins.synergy.impl.Command;
import hudson.plugins.synergy.impl.Conflict;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ProjectConflicts
extends Command {
    private String project;
    private List<Conflict> conflicts = new ArrayList<Conflict>();

    public ProjectConflicts(String project) {
        this.project = project;
    }

    @Override
    public String[] buildCommand(String ccmExe) {
        return new String[]{ccmExe, "conflicts", "-r", "-noformat", this.project};
    }

    @Override
    public void parseResult(String result) {
        BufferedReader reader = new BufferedReader(new StringReader(result));
        try {
            String line = reader.readLine();
            while (line != null) {
                if ((line = line.trim()).length() != 0 && !line.startsWith("Project:") && line.indexOf("No conflicts detected") == -1) {
                    StringTokenizer tokenizer = new StringTokenizer(line, "\t");
                    String objectname = tokenizer.nextToken();
                    String task = tokenizer.nextToken();
                    String message = tokenizer.nextToken();
                    int index = message.lastIndexOf("-");
                    String type = message.substring(index + 1).trim();
                    Conflict conflict = new Conflict(objectname, task, type, message);
                    this.conflicts.add(conflict);
                }
                line = reader.readLine();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public List<Conflict> getConflicts() {
        return this.conflicts;
    }
}

