/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.synergy.impl;

import hudson.plugins.synergy.impl.Command;
import hudson.plugins.synergy.impl.TaskCompleted;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.StringReader;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Locale;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TaskInfoCommand
extends Command {
    private DateFormat synergyFormat = new SimpleDateFormat("EE MMM dd hh:mm:ss yyyy", Locale.ENGLISH);
    private List<String> tasks;
    private List<TaskCompleted> informations;

    public TaskInfoCommand(List<String> tasks) {
        this.tasks = tasks;
    }

    @Override
    public String[] buildCommand(String ccmExe) {
        String[] commands = new String[]{ccmExe, "task", "-show", "info", this.tasks.get(0)};
        return commands;
    }

    @Override
    public void parseResult(String result) {
        this.informations = new ArrayList<TaskCompleted>();
        TaskCompleted task = null;
        try {
            BufferedReader reader = new BufferedReader(new StringReader(result));
            String line = reader.readLine();
            while (line != null) {
                if (line.startsWith("Task:")) {
                    task = new TaskCompleted();
                    this.informations.add(task);
                    task.setId(line.substring(line.indexOf(58) + 1).trim());
                } else if (line.indexOf("Synopsis:") != -1) {
                    task.setSynopsis(line.substring(line.indexOf(58) + 1).trim());
                } else if (line.indexOf("Resolver:") != -1) {
                    task.setResolver(line.substring(line.indexOf(58) + 1).trim());
                } else if (line.indexOf("Status set to 'completed'") != -1) {
                    try {
                        String dateAsString = line.substring(0, line.lastIndexOf(58));
                        Date date = this.synergyFormat.parse(dateAsString);
                        task.setDateCompleted(date);
                    }
                    catch (ParseException e) {
                        // empty catch block
                    }
                }
                line = reader.readLine();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public List<TaskCompleted> getInformations() {
        return this.informations;
    }
}

