/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.synergy.impl;

import hudson.plugins.synergy.impl.Command;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UpdateCommand
extends Command {
    private String project;
    private List<String> names;

    public UpdateCommand(String project) {
        this.project = project;
    }

    @Override
    public void parseResult(String result) {
        String elementParent;
        this.names = new ArrayList<String>();
        Pattern pReplaces = Pattern.compile("'[^']+'\\sreplaces\\s'[^']+'\\sunder\\s'[^']+'");
        Pattern pBoundUnder = Pattern.compile("'[^']+'\\sis\\snow\\sbound\\sunder\\s'[^']+'");
        Pattern pObjectName = Pattern.compile("'[^']+'");
        Matcher mReplaces = pReplaces.matcher(result);
        while (mReplaces.find()) {
            String group = mReplaces.group();
            Matcher mObjectNames = pObjectName.matcher(group);
            String newElement = mObjectNames.find() ? mObjectNames.group() : null;
            String oldElement = mObjectNames.find() ? mObjectNames.group() : null;
            elementParent = mObjectNames.find() ? mObjectNames.group() : null;
            this.names.add(newElement.substring(1, newElement.length() - 1));
        }
        Matcher mBound = pBoundUnder.matcher(result);
        while (mBound.find()) {
            String group = mBound.group();
            Matcher mObjectNames = pObjectName.matcher(group);
            String newElement = mObjectNames.find() ? mObjectNames.group() : null;
            elementParent = mObjectNames.find() ? mObjectNames.group() : null;
            this.names.add(newElement.substring(1, newElement.length() - 1));
        }
    }

    @Override
    public String[] buildCommand(String ccmExe) {
        String[] commands = new String[]{ccmExe, "update", "-r", "-rs", "-p", this.project};
        return commands;
    }

    public List<String> getUpdates() {
        return this.names;
    }

    @Override
    public boolean isStatusOK(int status) {
        return status == 0;
    }
}

