/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.synergy;

import hudson.model.AbstractBuild;
import hudson.model.User;
import hudson.plugins.synergy.SynergySCM;
import hudson.scm.ChangeLogSet;
import hudson.scm.EditType;
import java.io.IOException;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.kohsuke.stapler.export.Exported;
import org.kohsuke.stapler.export.ExportedBean;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class SynergyChangeLogSet
extends ChangeLogSet<LogEntry> {
    private final List<LogEntry> logs;
    private Map<String, Long> revisionMap;

    public SynergyChangeLogSet(AbstractBuild build, List<LogEntry> logs) {
        super(build);
        this.logs = Collections.unmodifiableList(logs);
        for (LogEntry log : logs) {
            log.setParent(this);
        }
    }

    public boolean isEmptySet() {
        return this.logs.isEmpty();
    }

    public List<LogEntry> getLogs() {
        return this.logs;
    }

    public Iterator<LogEntry> iterator() {
        return this.logs.iterator();
    }

    public synchronized Map<String, Long> getRevisionMap() throws IOException {
        if (this.revisionMap == null) {
            this.revisionMap = SynergySCM.parseRevisionFile(this.build);
        }
        return this.revisionMap;
    }

    @Exported
    public List<RevisionInfo> getRevisions() throws IOException {
        ArrayList<RevisionInfo> r = new ArrayList<RevisionInfo>();
        for (Map.Entry<String, Long> e : this.getRevisionMap().entrySet()) {
            r.add(new RevisionInfo(e.getKey(), e.getValue()));
        }
        return r;
    }

    @ExportedBean(defaultVisibility=999)
    public static class Path {
        private LogEntry entry;
        private char action;
        private String id;
        private String value;

        public String getId() {
            return this.id;
        }

        public void setId(String id) {
            this.id = id;
        }

        public LogEntry getLogEntry() {
            return this.entry;
        }

        public void setLogEntry(LogEntry entry) {
            this.entry = entry;
        }

        public void setAction(String action) {
            this.action = action.charAt(0);
        }

        @Exported(name="file")
        public String getValue() {
            return this.value;
        }

        public void setValue(String value) {
            this.value = value;
        }

        @Exported
        public EditType getEditType() {
            if (this.action == 'A') {
                return EditType.ADD;
            }
            if (this.action == 'D') {
                return EditType.DELETE;
            }
            return EditType.EDIT;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class LogEntry
    extends ChangeLogSet.Entry {
        private String taskId;
        private int version;
        private User author;
        private String date;
        private String msg;
        private List<Path> paths = new ArrayList<Path>();

        public SynergyChangeLogSet getParent() {
            return (SynergyChangeLogSet)super.getParent();
        }

        @Exported
        public String getTaskId() {
            return this.taskId;
        }

        @Exported
        public void setTaskId(String id) {
            this.taskId = id;
        }

        public User getAuthor() {
            if (this.author == null) {
                return User.getUnknown();
            }
            return this.author;
        }

        public Collection<String> getAffectedPaths() {
            return new AbstractList<String>(){

                @Override
                public String get(int index) {
                    return ((Path)LogEntry.this.paths.get(index)).value;
                }

                @Override
                public int size() {
                    return LogEntry.this.paths.size();
                }
            };
        }

        public void setUser(String author) {
            this.author = User.get((String)author);
        }

        @Exported
        public String getUser() {
            return this.author == null ? null : this.author.getDisplayName();
        }

        @Exported
        public String getDate() {
            return this.date;
        }

        public void setDate(String date) {
            this.date = date;
        }

        @Exported
        public String getMsg() {
            return this.msg;
        }

        public void setMsg(String msg) {
            this.msg = msg;
        }

        public void addPath(Path p) {
            p.entry = this;
            this.paths.add(p);
        }

        @Exported
        public List<Path> getPaths() {
            return this.paths;
        }

        public void setParent(SynergyChangeLogSet parent) {
            super.setParent((ChangeLogSet)parent);
        }

        @Exported
        public int getVersion() {
            return this.version;
        }

        @Exported
        public void setVersion(int version) {
            this.version = version;
        }
    }

    @ExportedBean(defaultVisibility=999)
    public static final class RevisionInfo {
        @Exported
        public final String module;
        @Exported
        public final long revision;

        public RevisionInfo(String module, long revision) {
            this.module = module;
            this.revision = revision;
        }
    }
}

