/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.synergy;

import hudson.FilePath;
import hudson.Launcher;
import hudson.model.AbstractBuild;
import hudson.model.BuildListener;
import hudson.model.Descriptor;
import hudson.model.Result;
import hudson.model.TaskListener;
import hudson.plugins.synergy.SynergySCM;
import hudson.plugins.synergy.impl.Commands;
import hudson.plugins.synergy.impl.CopyFolderCommand;
import hudson.plugins.synergy.impl.SynergyException;
import hudson.plugins.synergy.util.SessionUtils;
import hudson.scm.SCM;
import hudson.tasks.Publisher;
import java.io.IOException;
import net.sf.json.JSONObject;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.StaplerRequest;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SynergyFolderPublisher
extends Publisher {
    private boolean onlyOnSuccess;
    private String intFolder;
    private String devFolder;

    @DataBoundConstructor
    public SynergyFolderPublisher(Boolean onlyOnSuccess, String intFolder, String devFolder) {
        this.onlyOnSuccess = onlyOnSuccess;
        this.intFolder = intFolder;
        this.devFolder = devFolder;
    }

    public Descriptor<Publisher> getDescriptor() {
        return DescriptorImpl.DESCRIPTOR;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean perform(AbstractBuild<?, ?> build, Launcher launcher, BuildListener listener) throws InterruptedException, IOException {
        SCM scm = build.getProject().getScm();
        if (!(scm instanceof SynergySCM)) {
            listener.getLogger().println("No Folder copy for non Synergy project");
            return false;
        }
        boolean buildSucess = Result.SUCCESS.equals(build.getResult());
        boolean copyFolders = true;
        if (this.onlyOnSuccess && !buildSucess) {
            copyFolders = false;
        }
        if (copyFolders) {
            SynergySCM synergySCM = (SynergySCM)scm;
            FilePath path = build.getProject().getWorkspace();
            Commands commands = null;
            try {
                commands = SessionUtils.openSession(path, synergySCM, (TaskListener)listener, launcher);
                CopyFolderCommand copyFolderCommand = new CopyFolderCommand(this.getIntFolder(), this.getDevFolder());
                commands.executeSynergyCommand(path, copyFolderCommand);
            }
            catch (SynergyException e) {
                boolean bl = false;
                return bl;
            }
            finally {
                try {
                    if (commands != null) {
                        SessionUtils.closeSession(path, synergySCM, commands);
                    }
                }
                catch (SynergyException e) {
                    return false;
                }
            }
        }
        return true;
    }

    public void setPublish(boolean publish) {
        this.onlyOnSuccess = publish;
    }

    public boolean isPublish() {
        return this.onlyOnSuccess;
    }

    public void setIntFolder(String intFolder) {
        this.intFolder = intFolder;
    }

    public String getIntFolder() {
        return this.intFolder;
    }

    public void setDevFolder(String devFolder) {
        this.devFolder = devFolder;
    }

    public String getDevFolder() {
        return this.devFolder;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class DescriptorImpl
    extends Descriptor<Publisher> {
        public static DescriptorImpl DESCRIPTOR = new DescriptorImpl();

        private DescriptorImpl() {
            super(SynergyFolderPublisher.class);
        }

        public String getDisplayName() {
            return "Synergy Copy Folder";
        }

        public Publisher newInstance(StaplerRequest req, JSONObject formData) throws Descriptor.FormException {
            return new SynergyFolderPublisher(Boolean.parseBoolean(req.getParameter("synergyPublisher.publish")), req.getParameter("synergy.intFolder"), req.getParameter("synergy.devFolder"));
        }
    }
}

