/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.synergy;

import hudson.FilePath;
import hudson.Launcher;
import hudson.model.AbstractBuild;
import hudson.model.BuildListener;
import hudson.model.Descriptor;
import hudson.model.Result;
import hudson.model.TaskListener;
import hudson.plugins.synergy.SynergySCM;
import hudson.plugins.synergy.impl.Commands;
import hudson.plugins.synergy.impl.CreateProjectBaselineCommand;
import hudson.plugins.synergy.impl.PublishBaselineCommand;
import hudson.plugins.synergy.impl.SynergyException;
import hudson.plugins.synergy.util.SessionUtils;
import hudson.scm.SCM;
import hudson.tasks.Publisher;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.Date;
import net.sf.json.JSONObject;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.StaplerRequest;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SynergyPublisher
extends Publisher {
    private String time;
    private boolean publish;

    @DataBoundConstructor
    public SynergyPublisher(String time, boolean publish) {
        this.time = time;
        this.publish = publish;
    }

    public Descriptor<Publisher> getDescriptor() {
        return DescriptorImpl.DESCRIPTOR;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean perform(AbstractBuild<?, ?> build, Launcher launcher, BuildListener listener) throws InterruptedException, IOException {
        SCM scm = build.getProject().getScm();
        if (!(scm instanceof SynergySCM)) {
            listener.getLogger().println("No baseline publishing for non Synergy project");
            return false;
        }
        boolean createBaseline = false;
        boolean publishBaseline = false;
        boolean buildSucess = Result.SUCCESS.equals(build.getResult());
        String createBaselineAtPoint = this.getTime();
        if ("after".equals(createBaselineAtPoint)) {
            createBaseline = true;
        } else if ("success".equals(createBaselineAtPoint) && buildSucess) {
            createBaseline = true;
        }
        if (this.publish && buildSucess) {
            publishBaseline = true;
        }
        if (createBaseline || publishBaseline) {
            SynergySCM synergySCM = (SynergySCM)scm;
            String project = synergySCM.getProject();
            String purpose = synergySCM.getPurpose();
            String release = synergySCM.getRelease();
            FilePath path = build.getProject().getWorkspace();
            Commands commands = null;
            try {
                commands = SessionUtils.openSession(path, synergySCM, (TaskListener)listener, launcher);
                Date date = build.getTimestamp().getTime();
                SimpleDateFormat format = new SimpleDateFormat("yyyyMMdd-hhmm");
                String name = build.getProject().getName() + "-" + format.format(date);
                if (createBaseline) {
                    CreateProjectBaselineCommand createCommand = new CreateProjectBaselineCommand(name, project, release, purpose);
                    commands.executeSynergyCommand(path, createCommand);
                }
                if (publishBaseline) {
                    PublishBaselineCommand publishCommand = new PublishBaselineCommand(name);
                    commands.executeSynergyCommand(path, publishCommand);
                }
            }
            catch (SynergyException e) {
                boolean bl = false;
                return bl;
            }
            finally {
                try {
                    SessionUtils.closeSession(path, synergySCM, commands);
                }
                catch (SynergyException e) {
                    return false;
                }
            }
        }
        return true;
    }

    public void setPublish(boolean publish) {
        this.publish = publish;
    }

    public boolean isPublish() {
        return this.publish;
    }

    public String getTime() {
        return this.time;
    }

    public void setTime(String time) {
        this.time = time;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class DescriptorImpl
    extends Descriptor<Publisher> {
        public static DescriptorImpl DESCRIPTOR = new DescriptorImpl();

        private DescriptorImpl() {
            super(SynergyPublisher.class);
        }

        public String getDisplayName() {
            return "Create a Synergy Baseline";
        }

        public Publisher newInstance(StaplerRequest req, JSONObject formData) throws Descriptor.FormException {
            return new SynergyPublisher(req.getParameter("synergyPublisher.time"), Boolean.parseBoolean(req.getParameter("synergyPublisher.publish")));
        }
    }
}

