/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.synergy.impl;

import hudson.FilePath;
import hudson.Launcher;
import hudson.Proc;
import hudson.model.TaskListener;
import hudson.plugins.synergy.impl.Command;
import hudson.plugins.synergy.impl.StreamCommand;
import hudson.plugins.synergy.impl.SynergyException;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Map;

public class Commands
implements Serializable {
    private String ccmExe;
    private String ccmUiLog;
    private String ccmEngLog;
    private Launcher launcher;
    private String ccmAddr;
    private TaskListener buildListener;

    public TaskListener getTaskListener() {
        return this.buildListener;
    }

    public void setTaskListener(TaskListener buildListener) {
        this.buildListener = buildListener;
    }

    public String getCcmAddr() {
        return this.ccmAddr;
    }

    public void setCcmAddr(String ccmAddr) {
        this.ccmAddr = ccmAddr;
    }

    public Launcher getLauncher() {
        return this.launcher;
    }

    public void setLauncher(Launcher launcher) {
        this.launcher = launcher;
    }

    public String getCcmEngLog() {
        return this.ccmEngLog;
    }

    public void setCcmEngLog(String ccmEngLog) {
        this.ccmEngLog = ccmEngLog;
    }

    public String getCcmUiLog() {
        return this.ccmUiLog;
    }

    public void setCcmUiLog(String ccmUiLog) {
        this.ccmUiLog = ccmUiLog;
    }

    public String getCcmExe() {
        return this.ccmExe;
    }

    public void setCcmExe(String ccmExe) {
        this.ccmExe = ccmExe;
    }

    public String[] buildCompareProjectCommand(String newProject, String oldProject) {
        String[] query = new String[]{this.getCcmExe(), "query", "\"type!='project' and type!='dir' and is_member_of('" + newProject + "') and not is_member_of('" + oldProject + "')\"", "-u", "-f", "%%objectname"};
        return query;
    }

    public void executeSynergyCommand(FilePath path, Command command) throws IOException, InterruptedException, SynergyException {
        Map<String, String> system = System.getenv();
        ArrayList<String> param = new ArrayList<String>();
        for (Map.Entry<String, String> entry : system.entrySet()) {
            String s = entry.getKey() + "=" + entry.getValue();
            param.add(s);
        }
        if (this.ccmAddr != null) {
            param.add("CCM_ADDR=" + this.ccmAddr);
        }
        if (this.ccmUiLog != null) {
            param.add("CCM_UILOG=" + this.ccmUiLog);
        }
        if (this.ccmEngLog != null) {
            param.add("CCM_ENGLOG=" + this.ccmEngLog);
        }
        String[] env = param.toArray(new String[param.size()]);
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        String[] commands = command.buildCommand(this.ccmExe);
        boolean[] mask = command.buildMask();
        Proc proc = this.launcher.launch(commands, mask, env, null, (OutputStream)out, path);
        int result = proc.join();
        String output = out.toString();
        if (!command.isStatusOK(result)) {
            this.buildListener.getLogger().println("ccm command failed");
            this.buildListener.getLogger().println(output);
            this.buildListener.getLogger().println("The environment was :");
            for (String s : param) {
                this.buildListener.getLogger().println(s);
            }
            throw new SynergyException(result);
        }
        this.buildListener.getLogger().println(output);
        if (output != null) {
            if (output.endsWith("\r\n")) {
                output = output.substring(0, output.length() - 2);
            } else if (output.endsWith("\n")) {
                output = output.substring(0, output.length() - 1);
            }
        }
        command.parseResult(output);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void executeSynergyCommand(FilePath path, StreamCommand command) throws IOException, InterruptedException, SynergyException {
        int result;
        Map<String, String> system = System.getenv();
        ArrayList<String> param = new ArrayList<String>();
        for (Map.Entry<String, String> entry : system.entrySet()) {
            String s = entry.getKey() + "=" + entry.getValue();
            param.add(s);
        }
        if (this.ccmAddr != null) {
            param.add("CCM_ADDR=" + this.ccmAddr);
        }
        if (this.ccmUiLog != null) {
            param.add("CCM_UILOG=" + this.ccmUiLog);
        }
        if (this.ccmEngLog != null) {
            param.add("CCM_ENGLOG=" + this.ccmEngLog);
        }
        String[] env = param.toArray(new String[param.size()]);
        OutputStream out = command.buildResultOutputer();
        try {
            String[] commands = command.buildCommand(this.ccmExe);
            boolean[] mask = command.buildMask();
            Proc proc = this.launcher.launch(commands, mask, env, null, out, path);
            result = proc.join();
        }
        finally {
            out.close();
        }
        if (result != 0 && result != 1) {
            this.buildListener.getLogger().println("ccm command failed");
            this.buildListener.getLogger().println("The environment was :");
            for (String s : param) {
                this.buildListener.getLogger().println(s);
            }
            throw new SynergyException(result);
        }
    }
}

