/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.synergy.impl;

import hudson.plugins.synergy.impl.Command;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CompareProjectCommand
extends Command {
    private String newProject;
    private String oldProject;
    private List<String> differences;

    public CompareProjectCommand(String newProject, String oldProject) {
        this.newProject = newProject;
        this.oldProject = oldProject;
    }

    @Override
    public String[] buildCommand(String ccmExe) {
        String[] query = new String[]{ccmExe, "query", "\"type!='project' and type!='dir' and is_member_of('" + this.newProject + "') and not is_member_of('" + this.oldProject + "')\"", "-u", "-f", "%objectname"};
        return query;
    }

    @Override
    public void parseResult(String result) {
        String[] resultAsArray = result.split("\n");
        this.differences = new ArrayList<String>(resultAsArray.length);
        for (String difference : resultAsArray) {
            String trim = difference.trim();
            if (trim.length() <= 0) continue;
            this.differences.add(trim);
        }
    }

    public List<String> getDifferences() {
        return this.differences;
    }
}

