/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.synergy.impl;

import hudson.scm.EditType;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FileVersion {
    public static final String EDIT = "Edit";
    public static final String DELETE = "Delete";
    public static final String ADD = "Add";
    private String name;
    private String version;
    private String type;
    private String instance;
    private String projectPath;
    private String resolver;
    private int task;
    private String action;

    public FileVersion() {
    }

    public FileVersion(String name, String version, String type, String instance) {
        this.name = name;
        this.version = version;
        this.type = type;
        this.instance = instance;
    }

    public FileVersion(String name, String version, String type, String instance, String projectPath, String resolver, int task) {
        this.name = name;
        this.version = version;
        this.type = type;
        this.instance = instance;
        this.projectPath = projectPath;
        this.resolver = resolver;
        this.task = task;
    }

    public boolean equals(FileVersion file) {
        if (file != null) {
            super.equals(file);
            if (!(this.name == null || file.name != null && file.name.equals(this.name))) {
                return false;
            }
            if (!(this.version == null || file.version != null && file.version.equals(this.version))) {
                return false;
            }
            if (!(this.type == null || file.type != null && file.type.equals(this.type))) {
                return false;
            }
            if (!(this.instance == null || file.instance != null && file.instance.equals(this.instance))) {
                return false;
            }
            if (!(this.projectPath == null || file.projectPath != null && file.projectPath.equals(this.projectPath))) {
                return false;
            }
            if (!(this.resolver == null || file.resolver != null && file.resolver.equals(this.resolver))) {
                return false;
            }
            if (this.task > 0 && (file.task == 0 || file.task != this.task)) {
                return false;
            }
            return this.action == null || file.action != null && file.action.equals(this.action);
        }
        return false;
    }

    public boolean equalsTask(FileVersion file) {
        if (file != null) {
            super.equals(file);
            if (!(this.name == null || file.name != null && file.name.equals(this.name))) {
                return false;
            }
            if (!(this.version == null || file.version != null && file.version.equals(this.version))) {
                return false;
            }
            if (!(this.type == null || file.type != null && file.type.equals(this.type))) {
                return false;
            }
            return this.instance == null || file.instance != null && file.instance.equals(this.instance);
        }
        return false;
    }

    public boolean searchInList(List<FileVersion> files) {
        for (FileVersion fileSearch : files) {
            if (!fileSearch.equals(this)) continue;
            return true;
        }
        return false;
    }

    public FileVersion getSearchInList(List<FileVersion> files) {
        for (FileVersion fileSearch : files) {
            if (!fileSearch.equalsTask(this)) continue;
            return fileSearch;
        }
        return null;
    }

    public EditType fileToAdd() {
        return EditType.ADD;
    }

    public EditType fileToModify() {
        return EditType.EDIT;
    }

    public EditType fileToDelete() {
        return EditType.DELETE;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getVersion() {
        return this.version;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public String getInstance() {
        return this.instance;
    }

    public void setInstance(String instance) {
        this.instance = instance;
    }

    public String getResolver() {
        return this.resolver;
    }

    public void setResolver(String resolver) {
        this.resolver = resolver;
    }

    public int getTask() {
        return this.task;
    }

    public void setTask(int task) {
        this.task = task;
    }

    public String getAction() {
        return this.action;
    }

    public void setAction(String action) {
        this.action = action;
    }

    public String getProjectPath() {
        return this.projectPath;
    }

    public void setProjectPath(String projectPath) {
        this.projectPath = projectPath;
    }
}

