/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.synergy.impl;

import hudson.plugins.synergy.impl.Command;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.StringReader;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FindCompletedSinceDateCommand
extends Command {
    private Calendar calendar;
    private String release;
    private List<String> tasks;

    public FindCompletedSinceDateCommand(Calendar date, String release) {
        this.calendar = date;
        this.release = release;
    }

    @Override
    public String[] buildCommand(String ccmExe) {
        SimpleDateFormat format = new SimpleDateFormat("yyyy/MM/dd HH:mm:ss");
        String dateAsString = format.format(this.calendar.getTime());
        return new String[]{ccmExe, "query", "-t", "task", "-u", "-f", "%objectname", "completion_date >= time('" + dateAsString + "') and release='" + this.release + "'"};
    }

    @Override
    public void parseResult(String result) {
        this.tasks = new ArrayList<String>(1);
        try {
            BufferedReader reader = new BufferedReader(new StringReader(result));
            String line = reader.readLine();
            while (line != null) {
                if ((line = line.trim()).length() != 0) {
                    this.tasks.add(line);
                }
                line = reader.readLine();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public List<String> getTasks() {
        return this.tasks;
    }
}

