/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.synergy.impl;

import hudson.FilePath;
import hudson.plugins.synergy.impl.Command;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Properties;

public class StartCommand
extends Command {
    private String ccmAddr;
    private String login;
    private String database;
    private String engine;
    private String password;
    private boolean remoteClient;
    private String pathName;

    public StartCommand(String database, String engine, String login, String password, boolean remoteClient, String pathName) {
        this.database = database;
        this.engine = engine;
        this.login = login;
        this.password = password;
        this.remoteClient = remoteClient;
        this.pathName = pathName;
    }

    public String[] buildCommand(String ccmAddr) {
        String[] commands = new String[]{ccmAddr, "start", "-d", this.database, "-h", this.engine, "-n", this.login, "-nogui", "-m", "-q", "-pw", this.password};
        ArrayList<String> list = new ArrayList<String>(Arrays.asList(commands));
        if (this.remoteClient) {
            list.add("-rc");
        }
        if (this.pathName != null && this.pathName.length() != 0) {
            list.add("-u");
            list.add(this.pathName);
        }
        commands = list.toArray(new String[list.size()]);
        return commands;
    }

    public boolean[] buildMask() {
        boolean[] result = super.buildMask();
        int pwdIndex = 12;
        result[pwdIndex] = true;
        return result;
    }

    public void parseResult(String result) {
        this.ccmAddr = result;
    }

    public String getCcmAddr() {
        return this.ccmAddr;
    }

    public boolean isStatusOK(int status) {
        return status == 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addCcmAddrToSessionMapFile(FilePath ccmSessionMapFile) throws IOException, InterruptedException {
        InputStream is = null;
        OutputStream os = null;
        try {
            Properties properties = new Properties();
            if (ccmSessionMapFile.exists()) {
                is = ccmSessionMapFile.read();
                properties.load(is);
            }
            properties.put("ccmSession", this.ccmAddr);
            os = ccmSessionMapFile.write();
            properties.store(os, null);
        }
        finally {
            if (is != null) {
                is.close();
            }
            if (os != null) {
                os.close();
            }
        }
    }
}

