/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.synergy.impl;

import hudson.plugins.synergy.impl.Command;
import hudson.plugins.synergy.impl.Conflict;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UpdateCommand
extends Command {
    private String project;
    private List<String> names;
    private boolean replaceSubprojects;
    private List<Conflict> conflicts = new ArrayList<Conflict>();

    public UpdateCommand(String project, boolean replaceSubprojects) {
        this.project = project;
        this.replaceSubprojects = replaceSubprojects;
    }

    @Override
    public void parseResult(String result) {
        String elementParent;
        this.names = new ArrayList<String>();
        Pattern pReplaces = Pattern.compile("'[^']+'\\sreplaces\\s'[^']+'\\sunder\\s'[^']+'");
        Pattern pBoundUnder = Pattern.compile("'[^']+'\\sis\\snow\\sbound\\sunder\\s'[^']+'");
        Pattern pObjectName = Pattern.compile("'[^']+'");
        Matcher mReplaces = pReplaces.matcher(result);
        while (mReplaces.find()) {
            String group = mReplaces.group();
            Matcher mObjectNames = pObjectName.matcher(group);
            String newElement = mObjectNames.find() ? mObjectNames.group() : null;
            String oldElement = mObjectNames.find() ? mObjectNames.group() : null;
            elementParent = mObjectNames.find() ? mObjectNames.group() : null;
            this.names.add(newElement.substring(1, newElement.length() - 1));
        }
        Matcher mBound = pBoundUnder.matcher(result);
        while (mBound.find()) {
            String group = mBound.group();
            Matcher mObjectNames = pObjectName.matcher(group);
            String newElement = mObjectNames.find() ? mObjectNames.group() : null;
            elementParent = mObjectNames.find() ? mObjectNames.group() : null;
            this.names.add(newElement.substring(1, newElement.length() - 1));
        }
        Pattern updateWarningPattern = Pattern.compile("Warning:\\s.*");
        Matcher mUpdateWarningPattern = updateWarningPattern.matcher(result);
        boolean foundWarning = mUpdateWarningPattern.find();
        if (foundWarning) {
            String objectname = "Update Warning found!";
            String task = "No Task";
            String type = "";
            String message = mUpdateWarningPattern.group();
            Conflict conflict = new Conflict(objectname, task, type, message);
            this.conflicts.add(conflict);
        }
    }

    @Override
    public String[] buildCommand(String ccmExe) {
        String subprojectUpdateRule = this.replaceSubprojects ? "-replace_subprojects" : "-keep_subprojects";
        String[] commands = new String[]{ccmExe, "update", "-r", subprojectUpdateRule, "-p", this.project};
        return commands;
    }

    public List<String> getUpdates() {
        return this.names;
    }

    @Override
    public boolean isStatusOK(int status) {
        return status == 0;
    }

    public Collection<Conflict> getConflicts() {
        return this.conflicts;
    }

    public boolean isUpdateWarningsExists() {
        return !this.getConflicts().isEmpty();
    }
}

