/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.synergy.util;

import hudson.FilePath;
import hudson.Launcher;
import hudson.model.TaskListener;
import hudson.plugins.synergy.SynergySCM;
import hudson.plugins.synergy.impl.CheckSessionCommand;
import hudson.plugins.synergy.impl.Commands;
import hudson.plugins.synergy.impl.StartCommand;
import hudson.plugins.synergy.impl.StopCommand;
import hudson.plugins.synergy.impl.SynergyException;
import java.io.IOException;

public class SessionUtils {
    private static Commands configureCommands(SynergySCM synergySCM, TaskListener listener, Launcher launcher) {
        Commands commands = new Commands();
        commands.setCcmExe(synergySCM.getDescriptor().getCcmExe());
        commands.setCcmUiLog(synergySCM.getDescriptor().getCcmUiLog());
        commands.setCcmEngLog(synergySCM.getDescriptor().getCcmEngLog());
        commands.setTaskListener(listener);
        commands.setLauncher(launcher);
        return commands;
    }

    public static Commands openSession(FilePath path, SynergySCM synergySCM, TaskListener listener, Launcher launcher) throws IOException, InterruptedException, SynergyException {
        Commands commands = SessionUtils.configureCommands(synergySCM, listener, launcher);
        String ccmAddr = "SESSION_NOT_FOUND";
        FilePath ccmSessionMapFile = new FilePath(path, "ccmSessionMap.properties");
        if (synergySCM.isLeaveSessionOpen()) {
            CheckSessionCommand checkSessionCommand = new CheckSessionCommand();
            commands.executeSynergyCommand(path, checkSessionCommand);
            ccmAddr = checkSessionCommand.getCcmAddr(ccmSessionMapFile);
        }
        if ("SESSION_NOT_FOUND".equals(ccmAddr)) {
            ccmAddr = SessionUtils.startSession(path, synergySCM, commands, ccmSessionMapFile);
        }
        commands.setCcmAddr(ccmAddr);
        return commands;
    }

    private static String startSession(FilePath path, SynergySCM synergySCM, Commands commands, FilePath ccmSessionMapFile) throws IOException, InterruptedException, SynergyException {
        String database = synergySCM.getDatabase();
        String username = synergySCM.getUsername();
        String password = synergySCM.getPassword();
        boolean remoteClient = synergySCM.isRemoteClient();
        String pathName = synergySCM.getDescriptor().getPathName();
        String engine = synergySCM.getEngine();
        StartCommand startCommand = new StartCommand(database, engine, username, password, remoteClient, pathName);
        commands.executeSynergyCommand(path, startCommand);
        String ccmAddr = startCommand.getCcmAddr();
        startCommand.addCcmAddrToSessionMapFile(ccmSessionMapFile);
        return ccmAddr;
    }

    public static void closeSession(FilePath path, SynergySCM synergySCM, Commands commands) throws IOException, InterruptedException, SynergyException {
        if (!synergySCM.isLeaveSessionOpen() && commands != null) {
            StopCommand stopCommand = new StopCommand();
            commands.executeSynergyCommand(path, stopCommand);
        }
    }
}

