/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.systemloadaverage_monitor;

import hudson.model.Computer;
import hudson.model.Descriptor;
import hudson.model.Hudson;
import hudson.node_monitors.AbstractNodeMonitorDescriptor;
import hudson.node_monitors.NodeMonitor;
import hudson.remoting.Callable;
import java.io.IOException;
import java.lang.management.ManagementFactory;
import java.lang.management.OperatingSystemMXBean;
import net.sf.json.JSONObject;
import org.kohsuke.stapler.StaplerRequest;

public class SystemLoadAverageMonitor
extends NodeMonitor {
    public static final AbstractNodeMonitorDescriptor<String> DESCRIPTOR = new AbstractNodeMonitorDescriptor<String>(){

        protected String monitor(Computer c) throws IOException, InterruptedException {
            return (String)c.getChannel().call((Callable)new MonitorTask());
        }

        public SystemLoadAverageMonitor newInstance(StaplerRequest req, JSONObject formData) throws Descriptor.FormException {
            return new SystemLoadAverageMonitor();
        }

        public String getDisplayName() {
            return "System Load Average";
        }
    };

    public final String getColumnCaption() {
        return Hudson.getInstance().hasPermission(Hudson.ADMINISTER) ? super.getColumnCaption() : null;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static final class MonitorTask
    implements Callable<String, RuntimeException> {
        private static final long serialVersionUID = 1L;

        MonitorTask() {
        }

        public String call() {
            OperatingSystemMXBean opsysMXbean = ManagementFactory.getOperatingSystemMXBean();
            return new Long((long)opsysMXbean.getSystemLoadAverage()).toString();
        }
    }
}

