/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.tasks;

import edu.umd.cs.findbugs.annotations.SuppressWarnings;
import hudson.model.AbstractBuild;
import hudson.model.ModelObject;
import hudson.plugins.tasks.util.ChartBuilder;
import hudson.plugins.tasks.util.model.AnnotationContainer;
import hudson.plugins.tasks.util.model.AnnotationProvider;
import hudson.plugins.tasks.util.model.FileAnnotation;
import hudson.plugins.tasks.util.model.Priority;
import hudson.util.ChartUtil;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.jfree.chart.JFreeChart;
import org.kohsuke.stapler.StaplerRequest;
import org.kohsuke.stapler.StaplerResponse;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractTasksResult
extends AnnotationContainer
implements ModelObject {
    @SuppressWarnings(value={"Se"})
    private final AbstractBuild<?, ?> owner;
    private final String high;
    private final String normal;
    private final String low;

    public AbstractTasksResult(AbstractBuild<?, ?> owner, Collection<FileAnnotation> annotations, String high, String normal, String low) {
        this.owner = owner;
        this.high = high;
        this.normal = normal;
        this.low = low;
        this.addAnnotations(annotations);
    }

    protected final void annotationAdded(FileAnnotation annotation) {
    }

    public String getPackageCategoryName() {
        String fileName;
        if (this.hasAnnotations() && (fileName = ((FileAnnotation)this.getAnnotations().iterator().next()).getFileName()).endsWith(".cs")) {
            return "Namespace";
        }
        return "Package";
    }

    public final AbstractBuild<?, ?> getOwner() {
        return this.owner;
    }

    public final boolean isCurrent() {
        return ((AbstractBuild)this.getOwner().getProject().getLastBuild()).number == this.getOwner().number;
    }

    public List<String> getPriorities() {
        ArrayList<String> actualPriorities = new ArrayList<String>();
        for (String priority : this.getAvailablePriorities()) {
            if (this.getNumberOfAnnotations(priority) <= 0) continue;
            actualPriorities.add(priority);
        }
        return actualPriorities;
    }

    public Collection<String> getAvailablePriorities() {
        ArrayList<String> priorities = new ArrayList<String>();
        if (StringUtils.isNotEmpty((String)this.high)) {
            priorities.add(StringUtils.capitalize((String)StringUtils.lowerCase((String)Priority.HIGH.name())));
        }
        if (StringUtils.isNotEmpty((String)this.normal)) {
            priorities.add(StringUtils.capitalize((String)StringUtils.lowerCase((String)Priority.NORMAL.name())));
        }
        if (StringUtils.isNotEmpty((String)this.low)) {
            priorities.add(StringUtils.capitalize((String)StringUtils.lowerCase((String)Priority.LOW.name())));
        }
        return priorities;
    }

    public final String getTags(String priority) {
        return this.getTags(Priority.fromString((String)priority));
    }

    public final String getTags(Priority priority) {
        if (priority == Priority.HIGH) {
            return this.high;
        }
        if (priority == Priority.NORMAL) {
            return this.normal;
        }
        return this.low;
    }

    protected final void createDetailGraph(StaplerRequest request, StaplerResponse response, AnnotationProvider detailObject, int upperBound) throws IOException {
        if (ChartUtil.awtProblem) {
            response.sendRedirect2(request.getContextPath() + "/images/headless.png");
            return;
        }
        JFreeChart chart = ChartBuilder.createHighNormalLowChart((int)detailObject.getNumberOfAnnotations(Priority.HIGH), (int)detailObject.getNumberOfAnnotations(Priority.NORMAL), (int)detailObject.getNumberOfAnnotations(Priority.LOW), (int)upperBound);
        ChartUtil.generateGraph((StaplerRequest)request, (StaplerResponse)response, (JFreeChart)chart, (int)400, (int)20);
    }
}

