/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.tasks.util;

import hudson.Util;
import hudson.util.ChartUtil;
import hudson.util.StackedAreaRenderer2;
import org.jfree.data.category.CategoryDataset;

public final class PrioritiesAreaRenderer
extends StackedAreaRenderer2 {
    private static final long serialVersionUID = -4683951507836348304L;
    private final String url;
    private final String name;

    public PrioritiesAreaRenderer(String url, String name) {
        this.url = "/" + url + "/";
        this.name = name;
    }

    public String generateURL(CategoryDataset dataset, int row, int column) {
        return this.getLabel((CategoryDataset)dataset, (int)column).build.getNumber() + this.url;
    }

    public String generateToolTip(CategoryDataset dataset, int row, int column) {
        String prefix = row == 2 ? "high priority " : (row == 1 ? "normal " : "low priority ");
        return String.valueOf(Util.combine((long)dataset.getValue(row, column).intValue(), (String)(prefix + this.name)));
    }

    private ChartUtil.NumberOnlyBuildLabel getLabel(CategoryDataset dataset, int column) {
        return (ChartUtil.NumberOnlyBuildLabel)dataset.getColumnKey(column);
    }
}

