/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.tasks;

import hudson.plugins.tasks.TasksResult;

public final class ResultSummary {
    public static String createSummary(TasksResult project) {
        StringBuilder summary = new StringBuilder();
        int tasks = project.getNumberOfAnnotations();
        summary.append("Task Scanner: ");
        if (tasks > 0) {
            summary.append("<a href=\"tasksResult\">");
        }
        if (tasks == 1) {
            summary.append("1 open task");
        } else {
            summary.append(tasks + " open tasks");
        }
        if (tasks > 0) {
            summary.append("</a>");
        }
        summary.append(" ");
        if (project.getNumberOfFiles() > 1) {
            summary.append("in " + project.getNumberOfFiles() + " workspace files");
        } else {
            summary.append("in 1 workspace file");
        }
        if (project.getDelta() == 0) {
            summary.append(" (\u00b10).");
        } else if (project.getDelta() > 0) {
            summary.append(" (+" + project.getDelta() + ").");
        } else {
            summary.append(" (" + project.getDelta() + ").");
        }
        return summary.toString();
    }

    private ResultSummary() {
    }
}

