/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.tasks;

import com.thoughtworks.xstream.XStream;
import edu.umd.cs.findbugs.annotations.SuppressWarnings;
import hudson.XmlFile;
import hudson.model.AbstractBuild;
import hudson.model.ModelObject;
import hudson.plugins.tasks.ModuleDetail;
import hudson.plugins.tasks.PackageDetail;
import hudson.plugins.tasks.ResultSummary;
import hudson.plugins.tasks.parser.Task;
import hudson.plugins.tasks.parser.TasksProject;
import hudson.plugins.tasks.util.ChartRenderer;
import hudson.plugins.tasks.util.SourceDetail;
import hudson.plugins.tasks.util.model.AnnotationProvider;
import hudson.plugins.tasks.util.model.AnnotationStream;
import hudson.plugins.tasks.util.model.FileAnnotation;
import hudson.plugins.tasks.util.model.JavaPackage;
import hudson.plugins.tasks.util.model.JavaProject;
import hudson.plugins.tasks.util.model.MavenModule;
import hudson.plugins.tasks.util.model.Priority;
import hudson.plugins.tasks.util.model.WorkspaceFile;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.commons.lang.StringUtils;
import org.kohsuke.stapler.StaplerRequest;
import org.kohsuke.stapler.StaplerResponse;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TasksResult
implements ModelObject,
Serializable {
    private static final long serialVersionUID = -344808345805935004L;
    private static final Logger LOGGER = Logger.getLogger(TasksResult.class.getName());
    private static final XStream XSTREAM = new AnnotationStream();
    @SuppressWarnings(value={"Se"})
    private transient WeakReference<JavaProject> project;
    @SuppressWarnings(value={"Se"})
    private final AbstractBuild<?, ?> owner;
    private final String high;
    private final String normal;
    private final String low;
    private final int numberOfTasks;
    private final int delta;
    private final int highPriorityTasks;
    private final int lowPriorityTasks;
    private final int normalPriorityTasks;
    private int numberOfFiles;

    public TasksResult(AbstractBuild<?, ?> build, TasksProject project, String high, String normal, String low) {
        this(build, project, project.getNumberOfAnnotations(), high, normal, low);
    }

    public TasksResult(AbstractBuild<?, ?> build, TasksProject project, int previousNumberOfTasks, String high, String normal, String low) {
        this.owner = build;
        this.highPriorityTasks = project.getNumberOfAnnotations(Priority.HIGH);
        this.lowPriorityTasks = project.getNumberOfAnnotations(Priority.LOW);
        this.normalPriorityTasks = project.getNumberOfAnnotations(Priority.NORMAL);
        this.high = high;
        this.normal = normal;
        this.low = low;
        this.numberOfTasks = project.getNumberOfAnnotations();
        this.delta = this.numberOfTasks - previousNumberOfTasks;
        this.numberOfFiles = project.getNumberOfFiles();
        this.project = new WeakReference<TasksProject>(project);
        try {
            Collection<FileAnnotation> files = project.getAnnotations();
            this.getDataFile().write((Object)files.toArray(new FileAnnotation[files.size()]));
        }
        catch (IOException exception) {
            LOGGER.log(Level.WARNING, "Failed to serialize the open tasks result.", exception);
        }
    }

    public String getSummary() {
        return ResultSummary.createSummary(this);
    }

    public final boolean isCurrent() {
        return ((AbstractBuild)this.owner.getProject().getLastBuild()).number == this.owner.number;
    }

    public final AbstractBuild<?, ?> getOwner() {
        return this.owner;
    }

    public int getNumberOfFiles() {
        return this.numberOfFiles;
    }

    public int getNumberOfAnnotations() {
        return this.numberOfTasks;
    }

    public int getNumberOfAnnotations(Priority priority) {
        if (priority == Priority.HIGH) {
            return this.highPriorityTasks;
        }
        if (priority == Priority.NORMAL) {
            return this.normalPriorityTasks;
        }
        return this.lowPriorityTasks;
    }

    public int getNumberOfAnnotations(String priority) {
        return this.getNumberOfAnnotations(Priority.fromString(priority));
    }

    public String getDisplayName() {
        return "Open Tasks";
    }

    public int getDelta() {
        return this.delta;
    }

    public Collection<JavaPackage> getPackages() {
        return this.getProject().getPackages();
    }

    public synchronized JavaProject getProject() {
        AnnotationProvider result;
        if (this.project == null) {
            this.loadResult();
        }
        if ((result = (AnnotationProvider)this.project.get()) == null) {
            this.loadResult();
        }
        return (JavaProject)this.project.get();
    }

    private void loadResult() {
        JavaProject result;
        try {
            JavaProject newProject = new JavaProject();
            FileAnnotation[] annotations = (FileAnnotation[])this.getDataFile().read();
            newProject.addAnnotations(annotations);
            LOGGER.log(Level.INFO, "Loaded tasks data file " + this.getDataFile() + " for build " + this.getOwner().getNumber());
            result = newProject;
        }
        catch (IOException exception) {
            LOGGER.log(Level.WARNING, "Failed to load " + this.getDataFile(), exception);
            result = new JavaProject();
        }
        this.project = new WeakReference<JavaProject>(result);
    }

    private XmlFile getDataFile() {
        return new XmlFile(XSTREAM, new File(this.getOwner().getRootDir(), "open-tasks.xml"));
    }

    public Object getDynamic(String link, StaplerRequest request, StaplerResponse response) {
        if (this.isSingleModuleProject()) {
            if (this.isSinglePackageProject()) {
                return new SourceDetail(this.getOwner(), this.getProject().getAnnotation(link));
            }
            return new PackageDetail(this.getOwner(), this.getProject().getPackage(link), this.high, this.normal, this.low);
        }
        return new ModuleDetail(this.getOwner(), this.getProject().getModule(link), this.high, this.normal, this.low);
    }

    public String getToolTip(String name) {
        if (this.isSingleModuleProject()) {
            return this.getProject().getModules().iterator().next().getPackage(name).getToolTip();
        }
        return this.getProject().getModule(name).getToolTip();
    }

    public boolean isSingleModuleProject() {
        return this.getProject().getModules().size() == 1;
    }

    public boolean isSinglePackageProject() {
        return this.isSingleModuleProject() && this.getProject().getPackages().size() == 1;
    }

    public List<String> getPriorities() {
        ArrayList<String> actualPriorities = new ArrayList<String>();
        for (String priority : this.getAvailablePriorities()) {
            if (this.getNumberOfAnnotations(priority) <= 0) continue;
            actualPriorities.add(priority);
        }
        return actualPriorities;
    }

    public Collection<String> getAvailablePriorities() {
        ArrayList<String> priorities = new ArrayList<String>();
        if (StringUtils.isNotEmpty((String)this.high)) {
            priorities.add(StringUtils.capitalize((String)StringUtils.lowerCase((String)Priority.HIGH.name())));
        }
        if (StringUtils.isNotEmpty((String)this.normal)) {
            priorities.add(StringUtils.capitalize((String)StringUtils.lowerCase((String)Priority.NORMAL.name())));
        }
        if (StringUtils.isNotEmpty((String)this.low)) {
            priorities.add(StringUtils.capitalize((String)StringUtils.lowerCase((String)Priority.LOW.name())));
        }
        return priorities;
    }

    public final String getTags(String priority) {
        return this.getTags(Priority.fromString(priority));
    }

    public final String getTags(Priority priority) {
        if (priority == Priority.HIGH) {
            return this.high;
        }
        if (priority == Priority.NORMAL) {
            return this.normal;
        }
        return this.low;
    }

    public String getPackageCategoryName() {
        String fileName;
        if (this.hasAnnotations() && (fileName = this.getAnnotations().iterator().next().getFileName()).endsWith(".cs")) {
            return "Namespace";
        }
        return "Package";
    }

    public final void doModuleStatistics(StaplerRequest request, StaplerResponse response) throws IOException {
        ChartRenderer.renderPriorititesChart(request, response, this.getProject().getModule(request.getParameter("module")), this.getProject().getAnnotationBound());
    }

    public final void doPackageStatistics(StaplerRequest request, StaplerResponse response) throws IOException {
        MavenModule module = this.getProject().getModules().iterator().next();
        ChartRenderer.renderPriorititesChart(request, response, module.getPackage(request.getParameter("package")), module.getAnnotationBound());
    }

    public Collection<WorkspaceFile> getFiles() {
        return this.getProject().getFiles();
    }

    public final boolean hasAnnotations() {
        return this.getProject().hasAnnotations();
    }

    public final boolean hasAnnotations(String priority) {
        return this.getProject().hasAnnotations(priority);
    }

    public final FileAnnotation getAnnotation(String key) {
        return this.getProject().getAnnotation(key);
    }

    public final Collection<FileAnnotation> getAnnotations() {
        return this.getProject().getAnnotations();
    }

    public final Collection<FileAnnotation> getAnnotations(String priority) {
        return this.getProject().getAnnotations(priority);
    }

    static {
        XSTREAM.alias("task", Task.class);
    }
}

