/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.tasks;

import hudson.model.AbstractBuild;
import hudson.plugins.tasks.AbstractTasksResult;
import hudson.plugins.tasks.PackageDetail;
import hudson.plugins.tasks.util.SourceDetail;
import hudson.plugins.tasks.util.model.JavaPackage;
import hudson.plugins.tasks.util.model.MavenModule;
import hudson.plugins.tasks.util.model.Priority;
import hudson.plugins.tasks.util.model.WorkspaceFile;
import java.io.IOException;
import java.util.Collection;
import org.kohsuke.stapler.StaplerRequest;
import org.kohsuke.stapler.StaplerResponse;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ModuleDetail
extends AbstractTasksResult {
    private static final long serialVersionUID = -3743047168363581305L;
    private final MavenModule module;

    public ModuleDetail(AbstractBuild<?, ?> owner, MavenModule module, String high, String normal, String low) {
        super(owner, module.getAnnotations(), high, normal, low);
        this.module = module;
    }

    public String getDisplayName() {
        return this.module.getName();
    }

    public Collection<JavaPackage> getPackages() {
        return this.module.getPackages();
    }

    public Collection<WorkspaceFile> getFiles() {
        return this.module.getFiles();
    }

    public String getToolTip(String packageName) {
        return this.module.getPackage(packageName).getToolTip();
    }

    public final void doPackageStatistics(StaplerRequest request, StaplerResponse response) throws IOException {
        this.createDetailGraph(request, response, this.module.getPackage(request.getParameter("package")), this.module.getAnnotationBound());
    }

    public Object getDynamic(String link, StaplerRequest request, StaplerResponse response) {
        if (this.isSinglePackageModule()) {
            return new SourceDetail(this.getOwner(), this.getAnnotation(link));
        }
        return new PackageDetail(this.getOwner(), this.module.getPackage(link), this.getTags(Priority.HIGH), this.getTags(Priority.NORMAL), this.getTags(Priority.LOW));
    }

    public boolean isSinglePackageModule() {
        return this.module.getPackages().size() == 1;
    }
}

