/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.tasks;

import hudson.FilePath;
import hudson.maven.MavenBuild;
import hudson.maven.MavenBuildProxy;
import hudson.maven.MavenModule;
import hudson.maven.MavenReporter;
import hudson.maven.MavenReporterDescriptor;
import hudson.maven.MojoInfo;
import hudson.model.AbstractBuild;
import hudson.model.AbstractProject;
import hudson.model.Action;
import hudson.model.BuildListener;
import hudson.model.Result;
import hudson.model.Run;
import hudson.plugins.tasks.TasksProjectAction;
import hudson.plugins.tasks.TasksReporterDescriptor;
import hudson.plugins.tasks.TasksResult;
import hudson.plugins.tasks.TasksResultAction;
import hudson.plugins.tasks.parser.TasksProject;
import hudson.plugins.tasks.parser.WorkspaceScanner;
import hudson.plugins.tasks.util.AbortException;
import hudson.plugins.tasks.util.HealthReportBuilder;
import java.io.IOException;
import org.apache.commons.lang.StringUtils;
import org.apache.maven.project.MavenProject;

public class TasksReporter
extends MavenReporter {
    public static final TasksReporterDescriptor TASK_SCANNER_DESCRIPTOR = new TasksReporterDescriptor();
    private static final String DEFAULT_PATTERN = "**/*.java";
    private final String pattern;
    private final String threshold;
    private boolean isThresholdEnabled;
    private int minimumTasks;
    private final String healthy;
    private final String unHealthy;
    private int healthyTasks;
    private int unHealthyTasks;
    private boolean isHealthyReportEnabled;
    private final String high;
    private final String normal;
    private final String low;

    public TasksReporter(String pattern, String threshold, String healthy, String unHealthy, String high, String normal, String low) {
        this.threshold = threshold;
        this.healthy = healthy;
        this.unHealthy = unHealthy;
        this.pattern = pattern;
        this.high = high;
        this.normal = normal;
        this.low = low;
        if (!StringUtils.isEmpty((String)threshold)) {
            try {
                this.minimumTasks = Integer.valueOf(threshold);
                if (this.minimumTasks >= 0) {
                    this.isThresholdEnabled = true;
                }
            }
            catch (NumberFormatException exception) {
                // empty catch block
            }
        }
        if (!StringUtils.isEmpty((String)healthy) && !StringUtils.isEmpty((String)unHealthy)) {
            try {
                this.healthyTasks = Integer.valueOf(healthy);
                this.unHealthyTasks = Integer.valueOf(unHealthy);
                if (this.healthyTasks >= 0 && this.unHealthyTasks > this.healthyTasks) {
                    this.isHealthyReportEnabled = true;
                }
            }
            catch (NumberFormatException exception) {
                // empty catch block
            }
        }
    }

    public String getThreshold() {
        return this.threshold;
    }

    public String getHealthy() {
        return this.healthy;
    }

    public String getUnHealthy() {
        return this.unHealthy;
    }

    public String getPattern() {
        return this.pattern;
    }

    public String getHigh() {
        return this.high;
    }

    public String getNormal() {
        return this.normal;
    }

    public String getLow() {
        return this.low;
    }

    public boolean postExecute(MavenBuildProxy build, MavenProject pom, MojoInfo mojo, BuildListener listener, Throwable error) throws InterruptedException, IOException {
        TasksProject project;
        if (this.hasTaskResultAction(build).booleanValue()) {
            return true;
        }
        FilePath filePath = new FilePath(pom.getBasedir());
        try {
            listener.getLogger().println("Scanning workspace files for tasks...");
            project = (TasksProject)filePath.act((FilePath.FileCallable)new WorkspaceScanner(StringUtils.defaultIfEmpty((String)this.pattern, (String)DEFAULT_PATTERN), this.high, this.normal, this.low, pom.getName()));
        }
        catch (AbortException exception) {
            listener.getLogger().println(exception.getMessage());
            build.setResult(Result.FAILURE);
            return true;
        }
        build.execute((MavenBuildProxy.BuildCallable)new MavenBuildProxy.BuildCallable<Void, IOException>(){

            public Void call(MavenBuild build) throws IOException, InterruptedException {
                AbstractBuild previousBuild;
                TasksResultAction previousAction;
                Run previous = build.getPreviousBuild();
                TasksResult result = previous instanceof AbstractBuild ? ((previousAction = (TasksResultAction)(previousBuild = (AbstractBuild)previous).getAction(TasksResultAction.class)) == null ? new TasksResult((AbstractBuild<?, ?>)build, project, TasksReporter.this.high, TasksReporter.this.normal, TasksReporter.this.low) : new TasksResult((AbstractBuild<?, ?>)build, project, ((TasksResult)previousAction.getResult()).getNumberOfAnnotations(), TasksReporter.this.high, TasksReporter.this.normal, TasksReporter.this.low)) : new TasksResult((AbstractBuild<?, ?>)build, project, TasksReporter.this.high, TasksReporter.this.normal, TasksReporter.this.low);
                HealthReportBuilder healthReportBuilder = new HealthReportBuilder("Task Scanner", "open task", TasksReporter.this.isThresholdEnabled, TasksReporter.this.minimumTasks, TasksReporter.this.isHealthyReportEnabled, TasksReporter.this.healthyTasks, TasksReporter.this.unHealthyTasks);
                build.getActions().add(new TasksResultAction((AbstractBuild<?, ?>)build, result, healthReportBuilder));
                build.registerAsProjectAction((MavenReporter)TasksReporter.this);
                return null;
            }
        });
        int warnings = project.getNumberOfAnnotations();
        if (warnings > 0) {
            listener.getLogger().println("A total of " + warnings + " open tasks have been found.");
            if (this.isThresholdEnabled && warnings >= this.minimumTasks) {
                build.setResult(Result.UNSTABLE);
            }
        } else {
            listener.getLogger().println("No open tasks have been found.");
        }
        return true;
    }

    private Boolean hasTaskResultAction(MavenBuildProxy build) throws IOException, InterruptedException {
        return (Boolean)build.execute((MavenBuildProxy.BuildCallable)new MavenBuildProxy.BuildCallable<Boolean, IOException>(){

            public Boolean call(MavenBuild mavenBuild) throws IOException, InterruptedException {
                return mavenBuild.getAction(TasksResultAction.class) != null;
            }
        });
    }

    public Action getProjectAction(MavenModule module) {
        return new TasksProjectAction((AbstractProject<?, ?>)module);
    }

    public MavenReporterDescriptor getDescriptor() {
        return TASK_SCANNER_DESCRIPTOR;
    }
}

