/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.tasks.util;

import edu.umd.cs.findbugs.annotations.SuppressWarnings;
import hudson.model.AbstractBuild;
import hudson.model.HealthReport;
import hudson.model.HealthReportingAction;
import hudson.plugins.tasks.util.HealthReportBuilder;
import hudson.plugins.tasks.util.ResultAction;
import hudson.util.ChartUtil;
import java.io.IOException;
import org.jfree.chart.JFreeChart;
import org.kohsuke.stapler.StaplerProxy;
import org.kohsuke.stapler.StaplerRequest;
import org.kohsuke.stapler.StaplerResponse;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractResultAction<T>
implements StaplerProxy,
HealthReportingAction,
ResultAction<T> {
    private static final int HEIGHT = 200;
    private static final int WIDTH = 500;
    @SuppressWarnings(value={"Se"})
    private final AbstractBuild<?, ?> owner;
    private HealthReportBuilder healthReportBuilder;
    private T result;

    public AbstractResultAction(AbstractBuild<?, ?> owner, HealthReportBuilder healthReportBuilder, T result) {
        this.owner = owner;
        this.healthReportBuilder = healthReportBuilder;
        this.result = result;
    }

    @Override
    public final HealthReportBuilder getHealthReportBuilder() {
        if (this.healthReportBuilder == null) {
            this.healthReportBuilder = new HealthReportBuilder();
        }
        return this.healthReportBuilder;
    }

    public final HealthReport getBuildHealth() {
        return this.healthReportBuilder.computeHealth(this.getHealthCounter());
    }

    protected abstract int getHealthCounter();

    public final AbstractBuild<?, ?> getOwner() {
        return this.owner;
    }

    public final Object getTarget() {
        return this.getResult();
    }

    @Override
    public final T getResult() {
        return this.result;
    }

    @Override
    public final void setResult(T result) {
        this.result = result;
    }

    public String getIconFileName() {
        if (this.getHealthCounter() > 0) {
            return this.getIconUrl();
        }
        return null;
    }

    protected abstract String getIconUrl();

    @Override
    public final void doGraph(StaplerRequest request, StaplerResponse response) throws IOException {
        if (ChartUtil.awtProblem) {
            response.sendRedirect2(request.getContextPath() + "/images/headless.png");
            return;
        }
        ChartUtil.generateGraph((StaplerRequest)request, (StaplerResponse)response, (JFreeChart)this.createChart(request, response), (int)500, (int)200);
    }

    @Override
    public final void doGraphMap(StaplerRequest request, StaplerResponse response) throws IOException {
        ChartUtil.generateClickableMap((StaplerRequest)request, (StaplerResponse)response, (JFreeChart)this.createChart(request, response), (int)500, (int)200);
    }

    protected abstract JFreeChart createChart(StaplerRequest var1, StaplerResponse var2);
}

