/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.tasks;

import hudson.plugins.tasks.Messages;
import hudson.plugins.tasks.TasksResult;

public final class ResultSummary {
    public static String createSummary(TasksResult project) {
        StringBuilder summary = new StringBuilder();
        int tasks = project.getNumberOfAnnotations();
        summary.append(Messages.Tasks_ResultAction_Summary());
        summary.append(" ");
        if (tasks > 0) {
            summary.append("<a href=\"tasksResult\">");
        }
        if (tasks == 1) {
            summary.append(Messages.Tasks_ResultAction_OneWarning());
        } else {
            summary.append(Messages.Tasks_ResultAction_MultipleWarnings((Object)tasks));
        }
        if (tasks > 0) {
            summary.append("</a>");
        }
        summary.append(" ");
        if (project.getNumberOfFiles() > 1) {
            summary.append(Messages.Tasks_ResultAction_MultipleFiles((Object)project.getNumberOfFiles()));
        } else {
            summary.append(Messages.Tasks_ResultAction_OneFile());
        }
        if (project.getDelta() == 0) {
            summary.append(" (\u00b10).");
        } else if (project.getDelta() > 0) {
            summary.append(" (+" + project.getDelta() + ").");
        } else {
            summary.append(" (" + project.getDelta() + ").");
        }
        return summary.toString();
    }

    private ResultSummary() {
    }
}

