/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.tasks;

import hudson.FilePath;
import hudson.model.AbstractBuild;
import hudson.model.AbstractProject;
import hudson.model.Action;
import hudson.model.Descriptor;
import hudson.plugins.tasks.Messages;
import hudson.plugins.tasks.TasksDescriptor;
import hudson.plugins.tasks.TasksProjectAction;
import hudson.plugins.tasks.TasksResult;
import hudson.plugins.tasks.TasksResultAction;
import hudson.plugins.tasks.TasksResultBuilder;
import hudson.plugins.tasks.parser.TasksParserResult;
import hudson.plugins.tasks.parser.WorkspaceScanner;
import hudson.plugins.tasks.util.HealthAwarePublisher;
import hudson.plugins.tasks.util.HealthReportBuilder;
import hudson.tasks.Publisher;
import java.io.IOException;
import java.io.PrintStream;
import org.apache.commons.lang.StringUtils;
import org.kohsuke.stapler.DataBoundConstructor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TasksPublisher
extends HealthAwarePublisher {
    private static final String DEFAULT_PATTERN = "**/*.java";
    public static final TasksDescriptor TASK_SCANNER_DESCRIPTOR = new TasksDescriptor();
    private final String high;
    private final String normal;
    private final String low;
    private final String pattern;
    private final String excludePattern;

    @DataBoundConstructor
    public TasksPublisher(String pattern, String excludePattern, String threshold, String healthy, String unHealthy, String height, String high, String normal, String low) {
        super(threshold, healthy, unHealthy, height, "TASKS");
        this.pattern = pattern;
        this.excludePattern = excludePattern;
        this.high = high;
        this.normal = normal;
        this.low = low;
    }

    public String getPattern() {
        return this.pattern;
    }

    public String getExcludePattern() {
        return this.excludePattern;
    }

    public String getHigh() {
        return this.high;
    }

    public String getNormal() {
        return this.normal;
    }

    public String getLow() {
        return this.low;
    }

    public Action getProjectAction(AbstractProject<?, ?> project) {
        return new TasksProjectAction(project, this.getTrendHeight());
    }

    @Override
    public TasksParserResult perform(AbstractBuild<?, ?> build, PrintStream logger) throws InterruptedException, IOException {
        this.log(logger, "Scanning workspace files for tasks...");
        TasksParserResult project = (TasksParserResult)build.getProject().getWorkspace().act((FilePath.FileCallable)new WorkspaceScanner(StringUtils.defaultIfEmpty((String)this.getPattern(), (String)DEFAULT_PATTERN), this.getExcludePattern(), this.high, this.normal, this.low));
        TasksResult result = new TasksResultBuilder().build(build, project, this.high, this.normal, this.low);
        HealthReportBuilder healthReportBuilder = this.createHealthReporter(Messages.Tasks_ResultAction_HealthReportSingleItem(), Messages.Tasks_ResultAction_HealthReportMultipleItem("%d"));
        build.getActions().add(new TasksResultAction(build, healthReportBuilder, result));
        return project;
    }

    public Descriptor<Publisher> getDescriptor() {
        return TASK_SCANNER_DESCRIPTOR;
    }
}

