/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.tasks;

import hudson.FilePath;
import hudson.maven.MavenBuild;
import hudson.maven.MavenBuildProxy;
import hudson.maven.MavenModule;
import hudson.maven.MavenReporter;
import hudson.maven.MavenReporterDescriptor;
import hudson.maven.MojoInfo;
import hudson.model.AbstractBuild;
import hudson.model.AbstractProject;
import hudson.model.Action;
import hudson.plugins.tasks.MavenTasksResultAction;
import hudson.plugins.tasks.Messages;
import hudson.plugins.tasks.TasksProjectAction;
import hudson.plugins.tasks.TasksPublisher;
import hudson.plugins.tasks.TasksReporterDescriptor;
import hudson.plugins.tasks.TasksResult;
import hudson.plugins.tasks.TasksResultBuilder;
import hudson.plugins.tasks.parser.TasksParserResult;
import hudson.plugins.tasks.parser.WorkspaceScanner;
import hudson.plugins.tasks.util.HealthAwareMavenReporter;
import hudson.plugins.tasks.util.HealthReportBuilder;
import hudson.plugins.tasks.util.ParserResult;
import java.io.IOException;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.apache.maven.model.Resource;
import org.apache.maven.project.MavenProject;
import org.kohsuke.stapler.DataBoundConstructor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TasksReporter
extends HealthAwareMavenReporter {
    private static final long serialVersionUID = -4159947472293502606L;
    public static final TasksReporterDescriptor TASK_SCANNER_DESCRIPTOR = new TasksReporterDescriptor(TasksPublisher.TASK_SCANNER_DESCRIPTOR);
    private static final String DEFAULT_PATTERN = "**/*.java";
    private final String pattern;
    private final String excludePattern;
    private final String high;
    private final String normal;
    private final String low;
    private boolean isThresholdEnabled;
    private boolean isHealthyReportEnabled;
    private int healthyTasks;
    private int unHealthyTasks;
    private int minimumTasks;
    private String height;

    @DataBoundConstructor
    public TasksReporter(String pattern, String excludePattern, String threshold, String healthy, String unHealthy, String height, String high, String normal, String low) {
        super(threshold, healthy, unHealthy, height, "TASKS");
        this.pattern = pattern;
        this.excludePattern = excludePattern;
        this.high = high;
        this.normal = normal;
        this.low = low;
    }

    public String getPattern() {
        return this.pattern;
    }

    public String getExcludePattern() {
        return this.excludePattern;
    }

    public String getHigh() {
        return this.high;
    }

    public String getNormal() {
        return this.normal;
    }

    public String getLow() {
        return this.low;
    }

    @Override
    protected boolean acceptGoal(String goal) {
        return true;
    }

    @Override
    public TasksParserResult perform(MavenBuildProxy build, MavenProject pom, MojoInfo mojo, PrintStream logger) throws InterruptedException, IOException {
        ArrayList<String> foldersToScan = new ArrayList<String>(pom.getCompileSourceRoots());
        List resources = pom.getResources();
        for (Resource resource : resources) {
            foldersToScan.add(resource.getDirectory());
        }
        FilePath basedir = new FilePath(pom.getBasedir());
        TasksParserResult project = new TasksParserResult();
        for (String sourcePath : foldersToScan) {
            if (StringUtils.isEmpty((String)sourcePath)) continue;
            FilePath filePath = new FilePath(basedir, sourcePath);
            if (filePath.exists()) {
                this.log(logger, String.format("Scanning folder '%s' for tasks ... ", sourcePath));
                WorkspaceScanner workspaceScanner = new WorkspaceScanner(StringUtils.defaultIfEmpty((String)this.pattern, (String)DEFAULT_PATTERN), this.excludePattern, this.high, this.normal, this.low, pom.getName());
                workspaceScanner.setPrefix(sourcePath);
                TasksParserResult subProject = (TasksParserResult)filePath.act((FilePath.FileCallable)workspaceScanner);
                if (subProject.hasAnnotations()) {
                    project.addModules(subProject.getModules());
                }
                project.addScannedFiles(subProject.getNumberOfScannedFiles());
                this.log(logger, String.format("Found %d.", subProject.getNumberOfAnnotations()));
                continue;
            }
            this.log(logger, String.format("Scipping non-existent folder '%s'...", sourcePath));
        }
        return project;
    }

    @Override
    protected void persistResult(ParserResult project, MavenBuild build) {
        if (project instanceof TasksParserResult) {
            TasksResult result = new TasksResultBuilder().build((AbstractBuild<?, ?>)build, (TasksParserResult)project, this.high, this.normal, this.low);
            HealthReportBuilder healthReportBuilder = this.createHealthBuilder(Messages.Tasks_ResultAction_HealthReportSingleItem(), Messages.Tasks_ResultAction_HealthReportMultipleItem("%d"));
            build.getActions().add(new MavenTasksResultAction((AbstractBuild<?, ?>)build, healthReportBuilder, this.getHeight(), this.high, this.normal, this.low, result));
            build.registerAsProjectAction((MavenReporter)this);
        }
    }

    public Action getProjectAction(MavenModule module) {
        return new TasksProjectAction((AbstractProject<?, ?>)module, this.getTrendHeight());
    }

    @Override
    protected Class<? extends Action> getResultActionClass() {
        return MavenTasksResultAction.class;
    }

    public MavenReporterDescriptor getDescriptor() {
        return TASK_SCANNER_DESCRIPTOR;
    }
}

