/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.tasks;

import edu.umd.cs.findbugs.annotations.SuppressWarnings;
import hudson.model.AbstractBuild;
import hudson.plugins.tasks.TasksFileDetail;
import hudson.plugins.tasks.TasksModuleDetail;
import hudson.plugins.tasks.TasksPackageDetail;
import hudson.plugins.tasks.TasksPrioritiesDetail;
import hudson.plugins.tasks.TasksTabDetail;
import hudson.plugins.tasks.util.PrioritiesDetail;
import hudson.plugins.tasks.util.PriorityDetailFactory;
import hudson.plugins.tasks.util.SourceDetail;
import hudson.plugins.tasks.util.model.AnnotationContainer;
import hudson.plugins.tasks.util.model.Priority;
import org.apache.commons.lang.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TaskDetailBuilder {
    public Object getDynamic(String link, AbstractBuild<?, ?> owner, AnnotationContainer container, String displayName, final String high, final String normal, final String low) {
        PriorityDetailFactory factory = new PriorityDetailFactory(){

            @Override
            @SuppressWarnings(value={"IMA"})
            protected PrioritiesDetail createPrioritiesDetail(Priority priority, AbstractBuild<?, ?> build, AnnotationContainer container, String header) {
                return new TasksPrioritiesDetail(build, container, priority, header, high, normal, low);
            }
        };
        if (factory.isPriority(link)) {
            return factory.create(link, owner, container, displayName);
        }
        if (link.startsWith("module.")) {
            return new TasksModuleDetail(owner, container.getModule(StringUtils.substringAfter((String)link, (String)"module.")), displayName, high, normal, low);
        }
        if (link.startsWith("package.")) {
            return new TasksPackageDetail(owner, container.getPackage(StringUtils.substringAfter((String)link, (String)"package.")), displayName, high, normal, low);
        }
        if (link.startsWith("tab.tasks.")) {
            return new TasksTabDetail(owner, container, "/tasks/" + StringUtils.substringAfter((String)link, (String)"tab.tasks.") + ".jelly", high, normal, low);
        }
        if (link.startsWith("tab.")) {
            return new TasksTabDetail(owner, container, "/tabview/" + StringUtils.substringAfter((String)link, (String)"tab.") + ".jelly", high, normal, low);
        }
        if (link.startsWith("file.")) {
            return new TasksFileDetail(owner, container.getFile(Integer.valueOf(StringUtils.substringAfter((String)link, (String)"file."))), displayName, high, normal, low);
        }
        if (link.startsWith("source.")) {
            return new SourceDetail(owner, container.getAnnotation(StringUtils.substringAfter((String)link, (String)"source.")));
        }
        return null;
    }
}

