/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.tasks;

import edu.umd.cs.findbugs.annotations.SuppressWarnings;
import hudson.model.AbstractBuild;
import hudson.plugins.tasks.ResultSummary;
import hudson.plugins.tasks.TasksDetailBuilder;
import hudson.plugins.tasks.parser.Task;
import hudson.plugins.tasks.parser.TasksParserResult;
import hudson.plugins.tasks.util.BuildResult;
import hudson.plugins.tasks.util.Messages;
import hudson.plugins.tasks.util.model.AnnotationContainer;
import hudson.plugins.tasks.util.model.AnnotationProvider;
import hudson.plugins.tasks.util.model.FileAnnotation;
import hudson.plugins.tasks.util.model.JavaPackage;
import hudson.plugins.tasks.util.model.JavaProject;
import hudson.plugins.tasks.util.model.MavenModule;
import hudson.plugins.tasks.util.model.Priority;
import hudson.plugins.tasks.util.model.WorkspaceFile;
import java.io.IOException;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.commons.lang.StringUtils;
import org.kohsuke.stapler.StaplerRequest;
import org.kohsuke.stapler.StaplerResponse;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@SuppressWarnings(value={"PMD.TooManyFields"})
public class TasksResult
extends BuildResult {
    private static final long serialVersionUID = -344808345805935004L;
    private static final Logger LOGGER = Logger.getLogger(TasksResult.class.getName());
    @SuppressWarnings(value={"Se"})
    private transient WeakReference<JavaProject> project;
    private final String high;
    private final String normal;
    private final String low;
    private final int numberOfTasks;
    private final int delta;
    private final int highPriorityTasks;
    private final int lowPriorityTasks;
    private final int normalPriorityTasks;
    private final int numberOfFiles;

    public TasksResult(AbstractBuild<?, ?> build, TasksParserResult project, String high, String normal, String low) {
        this(build, project, project.getNumberOfAnnotations(), high, normal, low);
    }

    public TasksResult(AbstractBuild<?, ?> build, TasksParserResult project, int previousNumberOfTasks, String high, String normal, String low) {
        super(build, project.getModules());
        this.highPriorityTasks = project.getNumberOfAnnotations(Priority.HIGH);
        this.lowPriorityTasks = project.getNumberOfAnnotations(Priority.LOW);
        this.normalPriorityTasks = project.getNumberOfAnnotations(Priority.NORMAL);
        this.high = high;
        this.normal = normal;
        this.low = low;
        this.numberOfTasks = project.getNumberOfAnnotations();
        this.delta = this.numberOfTasks - previousNumberOfTasks;
        this.numberOfFiles = project.getNumberOfScannedFiles();
        try {
            Collection files = project.getAnnotations();
            this.getDataFile().write((Object)files.toArray(new FileAnnotation[files.size()]));
        }
        catch (IOException exception) {
            LOGGER.log(Level.WARNING, "Failed to serialize the open tasks result.", exception);
        }
    }

    public String getSummary() {
        return ResultSummary.createSummary((TasksResult)this);
    }

    public int getNumberOfFiles() {
        return this.numberOfFiles;
    }

    public int getNumberOfAnnotations() {
        return this.numberOfTasks;
    }

    public int getNumberOfAnnotations(Priority priority) {
        if (priority == Priority.HIGH) {
            return this.highPriorityTasks;
        }
        if (priority == Priority.NORMAL) {
            return this.normalPriorityTasks;
        }
        return this.lowPriorityTasks;
    }

    public String getDisplayName() {
        return hudson.plugins.tasks.Messages.Tasks_ProjectAction_Name();
    }

    public int getDelta() {
        return this.delta;
    }

    public Collection<JavaPackage> getPackages() {
        return this.getProject().getPackages();
    }

    public synchronized JavaProject getProject() {
        AnnotationProvider result;
        if (this.project == null) {
            this.loadResult();
        }
        if ((result = (AnnotationProvider)this.project.get()) == null) {
            this.loadResult();
        }
        return (JavaProject)this.project.get();
    }

    private void loadResult() {
        JavaProject result;
        try {
            JavaProject newProject = new JavaProject();
            FileAnnotation[] annotations = (FileAnnotation[])this.getDataFile().read();
            newProject.addAnnotations(annotations);
            LOGGER.log(Level.INFO, "Loaded tasks data file " + this.getDataFile() + " for build " + this.getOwner().getNumber());
            result = newProject;
        }
        catch (IOException exception) {
            LOGGER.log(Level.WARNING, "Failed to load " + this.getDataFile(), exception);
            result = new JavaProject();
        }
        this.project = new WeakReference<JavaProject>(result);
    }

    protected String getSerializationFileName() {
        return "open-tasks.xml";
    }

    public Object getDynamic(String link, StaplerRequest request, StaplerResponse response) {
        return new TasksDetailBuilder().getDynamic(link, this.getOwner(), this.getContainer(), this.getDisplayName(), this.getTags(Priority.HIGH), this.getTags(Priority.NORMAL), this.getTags(Priority.LOW));
    }

    public AnnotationContainer getContainer() {
        return this.getProject();
    }

    public MavenModule getModule(String name) {
        return this.getProject().getModule(name);
    }

    public List<String> getPriorities() {
        ArrayList<String> actualPriorities = new ArrayList<String>();
        for (String priority : this.getAvailablePriorities()) {
            if (this.getNumberOfAnnotations(priority) <= 0) continue;
            actualPriorities.add(priority);
        }
        return actualPriorities;
    }

    public Collection<String> getAvailablePriorities() {
        ArrayList<String> priorities = new ArrayList<String>();
        if (StringUtils.isNotEmpty((String)this.high)) {
            priorities.add(StringUtils.capitalize((String)StringUtils.lowerCase((String)Priority.HIGH.name())));
        }
        if (StringUtils.isNotEmpty((String)this.normal)) {
            priorities.add(StringUtils.capitalize((String)StringUtils.lowerCase((String)Priority.NORMAL.name())));
        }
        if (StringUtils.isNotEmpty((String)this.low)) {
            priorities.add(StringUtils.capitalize((String)StringUtils.lowerCase((String)Priority.LOW.name())));
        }
        return priorities;
    }

    public String getLocalizedPriority(String priorityName) {
        return Priority.fromString((String)priorityName).getLongLocalizedString();
    }

    public final String getTags(String priority) {
        return this.getTags(Priority.fromString((String)priority));
    }

    public final String getTags(Priority priority) {
        if (priority == Priority.HIGH) {
            return this.high;
        }
        if (priority == Priority.NORMAL) {
            return this.normal;
        }
        return this.low;
    }

    public String getPackageCategoryName() {
        String fileName;
        if (this.hasAnnotations() && (fileName = ((FileAnnotation)this.getAnnotations().iterator().next()).getFileName()).endsWith(".cs")) {
            return Messages.NamespaceDetail_header();
        }
        return Messages.PackageDetail_header();
    }

    public Collection<WorkspaceFile> getFiles() {
        return this.getProject().getFiles();
    }

    static {
        XSTREAM.alias("task", Task.class);
    }
}

