/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.tasks;

import hudson.model.AbstractBuild;
import hudson.plugins.tasks.Messages;
import hudson.plugins.tasks.TasksResult;
import hudson.plugins.tasks.util.AbstractResultAction;
import hudson.plugins.tasks.util.HealthReportBuilder;
import hudson.plugins.tasks.util.model.Priority;
import hudson.util.ChartUtil;
import hudson.util.DataSetBuilder;
import java.util.ArrayList;
import java.util.List;
import java.util.NoSuchElementException;
import org.apache.commons.lang.StringUtils;
import org.jfree.chart.JFreeChart;
import org.jfree.data.category.CategoryDataset;
import org.kohsuke.stapler.StaplerRequest;
import org.kohsuke.stapler.StaplerResponse;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TasksResultAction
extends AbstractResultAction<TasksResult> {
    private static final long serialVersionUID = -3936658973355672416L;
    private static final String TASKS_RESULT_URL = "tasksResult";

    public TasksResultAction(AbstractBuild<?, ?> owner, TasksResult result, HealthReportBuilder healthReportBuilder) {
        super(owner, healthReportBuilder, (Object)result);
    }

    protected int getHealthCounter() {
        return ((TasksResult)this.getResult()).getNumberOfAnnotations();
    }

    public String getDisplayName() {
        return Messages.Tasks_ProjectAction_Name();
    }

    public String getIconUrl() {
        return "/plugin/tasks/icons/tasks-24x24.png";
    }

    public String getUrlName() {
        return TASKS_RESULT_URL;
    }

    public TasksResultAction getPreviousResultAction() {
        TasksResultAction previousBuild = this.getPreviousBuild();
        if (previousBuild == null) {
            throw new NoSuchElementException("There is no previous build for action " + this);
        }
        return previousBuild;
    }

    private TasksResultAction getPreviousBuild() {
        TasksResultAction action;
        AbstractBuild build = this.getOwner();
        do {
            if ((build = (AbstractBuild)build.getPreviousBuild()) != null) continue;
            return null;
        } while ((action = (TasksResultAction)build.getAction(TasksResultAction.class)) == null);
        return action;
    }

    public boolean hasPreviousResultAction() {
        return this.getPreviousBuild() != null;
    }

    protected JFreeChart createChart(StaplerRequest request, StaplerResponse response) {
        String parameter = request.getParameter("useHealthBuilder");
        boolean useHealthBuilder = Boolean.valueOf(StringUtils.defaultIfEmpty((String)parameter, (String)"true"));
        return this.getHealthReportBuilder().createGraph(useHealthBuilder, TASKS_RESULT_URL, this.buildDataSet(useHealthBuilder), Messages.Tasks_ResultAction_OneWarning(), Messages.Tasks_ResultAction_MultipleWarnings((Object)"%d"));
    }

    private CategoryDataset buildDataSet(boolean useHealthBuilder) {
        DataSetBuilder builder = new DataSetBuilder();
        for (TasksResultAction action = this; action != null; action = action.getPreviousBuild()) {
            List<Integer> series;
            TasksResult current = (TasksResult)action.getResult();
            if (current == null) continue;
            if (useHealthBuilder && this.getHealthReportBuilder().isEnabled()) {
                series = this.getHealthReportBuilder().createSeries(current.getNumberOfAnnotations());
            } else {
                series = new ArrayList<Integer>();
                series.add(current.getNumberOfAnnotations(Priority.LOW));
                series.add(current.getNumberOfAnnotations(Priority.NORMAL));
                series.add(current.getNumberOfAnnotations(Priority.HIGH));
            }
            int level = 0;
            for (Integer integer : series) {
                builder.add((Number)integer, (Comparable)Integer.valueOf(level), (Comparable)new ChartUtil.NumberOnlyBuildLabel(action.getOwner()));
                ++level;
            }
        }
        return builder.build();
    }
}

