/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.tasks.parser;

import hudson.FilePath;
import hudson.plugins.tasks.parser.CsharpNamespaceDetector;
import hudson.plugins.tasks.parser.JavaPackageDetector;
import hudson.plugins.tasks.parser.PackageDetector;
import hudson.plugins.tasks.parser.Task;
import hudson.plugins.tasks.parser.TaskScanner;
import hudson.plugins.tasks.parser.TasksProject;
import hudson.plugins.tasks.util.AbortException;
import hudson.plugins.tasks.util.MavenModuleDetector;
import hudson.remoting.VirtualChannel;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.types.FileSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WorkspaceScanner
implements FilePath.FileCallable<TasksProject> {
    private static final long serialVersionUID = -4355362392102020724L;
    private final String filePattern;
    private String moduleName;
    private final String high;
    private final String normal;
    private final String low;

    public WorkspaceScanner(String filePattern, String high, String normal, String low) {
        this.filePattern = filePattern;
        this.high = high;
        this.normal = normal;
        this.low = low;
    }

    public WorkspaceScanner(String filePattern, String high, String normal, String low, String moduleName) {
        this(filePattern, high, normal, low);
        this.moduleName = moduleName;
    }

    public TasksProject invoke(File workspace, VirtualChannel channel) throws IOException {
        String[] files = this.findFiles(workspace);
        if (files.length == 0) {
            throw new AbortException("No files were found that match the pattern '" + this.filePattern + "'. Configuration error?");
        }
        ArrayList<Object> detectors = new ArrayList<Object>();
        detectors.add(new JavaPackageDetector());
        detectors.add(new CsharpNamespaceDetector());
        TaskScanner taskScanner = new TaskScanner(this.high, this.normal, this.low);
        TasksProject javaProject = new TasksProject(files.length);
        MavenModuleDetector moduleDetector = new MavenModuleDetector();
        for (String fileName : files) {
            File originalFile = new File(workspace, fileName);
            Collection tasks = taskScanner.scan(new FilePath(originalFile).read());
            if (tasks.isEmpty()) continue;
            String unixName = fileName.replace('\\', '/');
            String packageName = this.detectPackageName(detectors, unixName, new FilePath(originalFile).read());
            String actualModule = StringUtils.defaultIfEmpty((String)this.moduleName, (String)moduleDetector.guessModuleName(originalFile.getAbsolutePath()));
            for (Task task : tasks) {
                task.setFileName(unixName);
                task.setPackageName(packageName);
                task.setModuleName(actualModule);
            }
            javaProject.addAnnotations(tasks);
        }
        return javaProject;
    }

    private String detectPackageName(List<PackageDetector> detectors, String fileName, InputStream content) throws IOException {
        for (PackageDetector detector : detectors) {
            if (!detector.accepts(fileName)) continue;
            return detector.detectPackageName(content);
        }
        return "";
    }

    private String[] findFiles(File workspaceRoot) {
        FileSet fileSet = new FileSet();
        Project project = new Project();
        fileSet.setProject(project);
        fileSet.setDir(workspaceRoot);
        fileSet.setIncludes(this.filePattern);
        return fileSet.getDirectoryScanner(project).getIncludedFiles();
    }
}

