/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.tasks.util;

import edu.umd.cs.findbugs.annotations.SuppressWarnings;
import hudson.model.AbstractBuild;
import hudson.model.AbstractProject;
import hudson.model.Action;
import hudson.plugins.tasks.util.ResultAction;
import java.io.IOException;
import java.util.List;
import javax.servlet.http.Cookie;
import org.kohsuke.stapler.Ancestor;
import org.kohsuke.stapler.StaplerRequest;
import org.kohsuke.stapler.StaplerResponse;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractProjectAction<T extends ResultAction<?>>
implements Action {
    private static final int ONE_YEAR = 31536000;
    @SuppressWarnings(value={"Se"})
    private final AbstractProject<?, ?> project;
    private final Class<T> resultActionType;
    private final String iconUrl;
    private final String resultsUrl;

    public AbstractProjectAction(AbstractProject<?, ?> project, Class<T> resultActionType, String iconUrl, String pluginName) {
        this.project = project;
        this.resultActionType = resultActionType;
        this.iconUrl = iconUrl;
        this.resultsUrl = pluginName + "Result";
    }

    public final boolean isHealthinessEnabled() {
        ResultAction lastAction = this.getLastAction();
        if (lastAction != null) {
            return lastAction.getHealthReportBuilder().isEnabled();
        }
        return false;
    }

    public final AbstractProject<?, ?> getProject() {
        return this.project;
    }

    public final boolean hasValidResults(AbstractBuild<?, ?> build) {
        ResultAction resultAction;
        if (build != null && (resultAction = (ResultAction)build.getAction(this.resultActionType)) != null) {
            return resultAction.hasPreviousResultAction();
        }
        return false;
    }

    public String getIconFileName() {
        if (this.getLastAction() != null) {
            return this.iconUrl;
        }
        return null;
    }

    public ResultAction<?> getLastAction() {
        AbstractBuild lastBuild = this.getLastFinishedBuild();
        if (lastBuild != null) {
            return (ResultAction)lastBuild.getAction(this.resultActionType);
        }
        return null;
    }

    public void doTrend(StaplerRequest request, StaplerResponse response) throws IOException {
        this.createGraph(request, response);
    }

    private void createGraph(StaplerRequest request, StaplerResponse response) throws IOException {
        ResultAction action = this.getLastAction();
        if (action == null) {
            response.setStatus(404);
        } else {
            action.doGraph(request, response);
        }
    }

    public void doTrendMap(StaplerRequest request, StaplerResponse response) throws IOException {
        ResultAction action = this.getLastAction();
        if (action == null) {
            response.setStatus(404);
        } else {
            action.doGraphMap(request, response);
        }
    }

    public void doIndex(StaplerRequest request, StaplerResponse response) throws IOException {
        AbstractBuild build = this.getLastFinishedBuild();
        if (build != null) {
            response.sendRedirect2("../" + build.getNumber() + "/" + this.resultsUrl);
        }
    }

    private AbstractBuild<?, ?> getLastFinishedBuild() {
        AbstractBuild lastBuild;
        for (lastBuild = (AbstractBuild)this.project.getLastBuild(); lastBuild != null && lastBuild.isBuilding(); lastBuild = (AbstractBuild)lastBuild.getPreviousBuild()) {
        }
        return lastBuild;
    }

    public void doFlipTrend(StaplerRequest request, StaplerResponse response) throws IOException {
        boolean useHealthBuilder = true;
        Cookie[] cookies = request.getCookies();
        if (cookies != null) {
            for (Cookie cookie : cookies) {
                if (!cookie.getName().equals(this.getCookieName())) continue;
                useHealthBuilder = Boolean.parseBoolean(cookie.getValue());
            }
        }
        useHealthBuilder = !useHealthBuilder;
        Cookie cookie = new Cookie(this.getCookieName(), String.valueOf(useHealthBuilder));
        List ancestors = request.getAncestors();
        Ancestor ancestor = (Ancestor)ancestors.get(ancestors.size() - 2);
        cookie.setPath(ancestor.getUrl());
        cookie.setMaxAge(31536000);
        response.addCookie(cookie);
        response.sendRedirect("..");
    }

    protected abstract String getCookieName();
}

