/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.tasks.util;

import hudson.model.AbstractBuild;
import hudson.plugins.tasks.util.AbstractAnnotationsDetail;
import hudson.plugins.tasks.util.Messages;
import hudson.plugins.tasks.util.PackageDetail;
import hudson.plugins.tasks.util.model.AnnotationProvider;
import hudson.plugins.tasks.util.model.JavaPackage;
import hudson.plugins.tasks.util.model.MavenModule;
import hudson.plugins.tasks.util.model.WorkspaceFile;
import java.io.IOException;
import java.util.Collection;
import org.kohsuke.stapler.StaplerRequest;
import org.kohsuke.stapler.StaplerResponse;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ModuleDetail
extends AbstractAnnotationsDetail {
    private static final long serialVersionUID = -1854984151887397361L;
    private final MavenModule module;

    public ModuleDetail(AbstractBuild<?, ?> owner, MavenModule module, String header) {
        super(owner, module.getAnnotations(), header);
        this.module = module;
    }

    public String getDisplayName() {
        return this.module.getName();
    }

    public String getHeader() {
        return this.getName() + " - " + Messages.ModuleDetail_header() + " " + this.module.getName();
    }

    public MavenModule getModule() {
        return this.module;
    }

    public Collection<JavaPackage> getPackages() {
        return this.module.getPackages();
    }

    public boolean isSinglePackageModule() {
        return this.getPackages().size() == 1;
    }

    public final void doPackageStatistics(StaplerRequest request, StaplerResponse response) throws IOException {
        this.createDetailGraph(request, response, (AnnotationProvider)this.module.getPackage(request.getParameter("package")), this.module.getAnnotationBound());
    }

    public AbstractAnnotationsDetail getDynamic(String link) {
        if (this.isSinglePackageModule()) {
            return null;
        }
        return new PackageDetail(this.getOwner(), this.module.getPackage(link), this.getName());
    }

    public String getToolTip(String packageName) {
        return this.module.getPackage(packageName).getToolTip();
    }

    public Collection<WorkspaceFile> getFiles() {
        return this.module.getFiles();
    }

    public WorkspaceFile getFile(String fileName) {
        return this.module.getFile(fileName);
    }
}

