/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.tasks.util.model;

import hudson.plugins.tasks.util.Messages;
import hudson.plugins.tasks.util.model.AnnotationProvider;
import hudson.plugins.tasks.util.model.FileAnnotation;
import hudson.plugins.tasks.util.model.Priority;
import hudson.plugins.tasks.util.model.WorkspaceFile;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import org.apache.commons.lang.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AnnotationContainer
implements AnnotationProvider,
Serializable {
    private static final long serialVersionUID = 855696821788264261L;
    private final Map<Long, FileAnnotation> annotations = new HashMap();
    private transient Map<Priority, Set<FileAnnotation>> annotationsByPriority;
    private boolean handleFiles;
    private transient Map<String, WorkspaceFile> filesByName;
    private String name;

    public AnnotationContainer() {
        this(false, "");
    }

    public final String getName() {
        return this.name;
    }

    public final void setName(String name) {
        this.name = name;
    }

    protected AnnotationContainer(boolean handleFiles, String name) {
        this.initialize(handleFiles);
        this.name = name;
    }

    private void initialize(boolean handleFilesByContainer) {
        this.annotationsByPriority = new EnumMap(Priority.class);
        for (Priority priority : Priority.values()) {
            this.annotationsByPriority.put(priority, new HashSet());
        }
        this.filesByName = new HashMap();
        this.handleFiles = handleFilesByContainer;
    }

    private Object readResolve() {
        this.rebuildMappings(this.handleFiles);
        return this;
    }

    protected void rebuildMappings(boolean handleFilesByContainer) {
        this.initialize(handleFilesByContainer);
        for (FileAnnotation annotation : this.getAnnotations()) {
            ((Set)this.annotationsByPriority.get(annotation.getPriority())).add(annotation);
            if (!handleFilesByContainer) continue;
            this.addFile(annotation);
        }
    }

    protected final void addFile(FileAnnotation annotation) {
        String fileName = annotation.getFileName();
        if (!this.filesByName.containsKey(fileName)) {
            this.filesByName.put(fileName, new WorkspaceFile(fileName));
        }
        ((WorkspaceFile)this.filesByName.get(fileName)).addAnnotation(annotation);
    }

    public final void addAnnotation(FileAnnotation annotation) {
        this.annotations.put(annotation.getKey(), annotation);
        ((Set)this.annotationsByPriority.get(annotation.getPriority())).add(annotation);
        this.annotationAdded(annotation);
    }

    public final void addAnnotations(Collection<? extends FileAnnotation> newAnnotations) {
        for (FileAnnotation fileAnnotation : newAnnotations) {
            this.addAnnotation(fileAnnotation);
        }
    }

    public final void addAnnotations(FileAnnotation[] newAnnotations) {
        this.addAnnotations(Arrays.asList(newAnnotations));
    }

    protected void annotationAdded(FileAnnotation annotation) {
        if (this.handleFiles) {
            this.addFile(annotation);
        }
    }

    public final Collection<FileAnnotation> getAnnotations() {
        return Collections.unmodifiableCollection(this.annotations.values());
    }

    public final Collection<FileAnnotation> getAnnotations(Priority priority) {
        return Collections.unmodifiableCollection((Collection)this.annotationsByPriority.get(priority));
    }

    public final Collection<FileAnnotation> getAnnotations(String priority) {
        return this.getAnnotations(this.getPriority(priority));
    }

    private Priority getPriority(String priority) {
        return Priority.fromString((String)priority);
    }

    public int getNumberOfAnnotations() {
        return this.annotations.size();
    }

    public int getNumberOfAnnotations(Priority priority) {
        return ((Set)this.annotationsByPriority.get(priority)).size();
    }

    public final int getNumberOfAnnotations(String priority) {
        return this.getNumberOfAnnotations(this.getPriority(priority));
    }

    public final boolean hasAnnotations() {
        return !this.annotations.isEmpty();
    }

    public final boolean hasAnnotations(Priority priority) {
        return !((Set)this.annotationsByPriority.get(priority)).isEmpty();
    }

    public final boolean hasAnnotations(String priority) {
        return this.hasAnnotations(this.getPriority(priority));
    }

    public final FileAnnotation getAnnotation(long key) {
        FileAnnotation annotation = (FileAnnotation)this.annotations.get(key);
        if (annotation != null) {
            return annotation;
        }
        throw new NoSuchElementException("Annotation not found: key=" + key);
    }

    public final FileAnnotation getAnnotation(String key) {
        return this.getAnnotation(Long.parseLong(key));
    }

    public String getToolTip() {
        StringBuilder message = new StringBuilder();
        for (Priority priority : Priority.values()) {
            if (!this.hasAnnotations(priority)) continue;
            message.append(priority.getLocalizedString());
            message.append(":");
            message.append(this.getNumberOfAnnotations(priority));
            message.append(" - ");
        }
        return StringUtils.removeEnd((String)message.toString(), (String)" - ");
    }

    public final String getPackageCategoryName() {
        String fileName;
        if (this.hasAnnotations() && (fileName = ((FileAnnotation)this.getAnnotations().iterator().next()).getFileName()).endsWith(".cs")) {
            return Messages.NamespaceDetail_header();
        }
        return Messages.PackageDetail_header();
    }

    public Collection<WorkspaceFile> getFiles() {
        if (this.handleFiles) {
            return Collections.unmodifiableCollection(this.filesByName.values());
        }
        return Collections.EMPTY_LIST;
    }

    public WorkspaceFile getFile(String fileName) {
        if (this.handleFiles && this.filesByName.containsKey(fileName)) {
            return (WorkspaceFile)this.filesByName.get(fileName);
        }
        throw new NoSuchElementException("File not found: " + fileName);
    }
}

