/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.tasks;

import hudson.FilePath;
import hudson.Launcher;
import hudson.model.AbstractBuild;
import hudson.model.AbstractProject;
import hudson.model.Action;
import hudson.model.BuildListener;
import hudson.model.Descriptor;
import hudson.model.Result;
import hudson.model.Run;
import hudson.plugins.tasks.Messages;
import hudson.plugins.tasks.TasksDescriptor;
import hudson.plugins.tasks.TasksProjectAction;
import hudson.plugins.tasks.TasksResult;
import hudson.plugins.tasks.TasksResultAction;
import hudson.plugins.tasks.parser.TasksProject;
import hudson.plugins.tasks.parser.WorkspaceScanner;
import hudson.plugins.tasks.util.AbortException;
import hudson.plugins.tasks.util.HealthAwarePublisher;
import hudson.plugins.tasks.util.HealthReportBuilder;
import hudson.tasks.Publisher;
import java.io.IOException;
import org.apache.commons.lang.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TasksPublisher
extends HealthAwarePublisher {
    private static final String DEFAULT_PATTERN = "**/*.java";
    public static final TasksDescriptor TASK_SCANNER_DESCRIPTOR = new TasksDescriptor();
    private final String high;
    private final String normal;
    private final String low;

    public TasksPublisher(String pattern, String threshold, String healthy, String unHealthy, String high, String normal, String low) {
        super(pattern, threshold, healthy, unHealthy);
        this.high = high;
        this.normal = normal;
        this.low = low;
    }

    public String getHigh() {
        return this.high;
    }

    public String getNormal() {
        return this.normal;
    }

    public String getLow() {
        return this.low;
    }

    public Action getProjectAction(AbstractProject<?, ?> project) {
        return new TasksProjectAction(project);
    }

    public boolean perform(AbstractBuild<?, ?> build, Launcher launcher, BuildListener listener) throws InterruptedException, IOException {
        AbstractBuild previousBuild;
        TasksResultAction previousAction;
        TasksProject project;
        try {
            listener.getLogger().println("Scanning workspace files for tasks...");
            project = (TasksProject)build.getProject().getWorkspace().act((FilePath.FileCallable)new WorkspaceScanner(StringUtils.defaultIfEmpty((String)this.getPattern(), (String)DEFAULT_PATTERN), this.high, this.normal, this.low));
        }
        catch (AbortException exception) {
            listener.getLogger().println(exception.getMessage());
            build.setResult(Result.FAILURE);
            return false;
        }
        Run previous = build.getPreviousBuild();
        TasksResult result = previous instanceof AbstractBuild ? ((previousAction = (TasksResultAction)(previousBuild = (AbstractBuild)previous).getAction(TasksResultAction.class)) == null ? new TasksResult(build, project, this.high, this.normal, this.low) : new TasksResult(build, project, ((TasksResult)previousAction.getResult()).getNumberOfAnnotations(), this.high, this.normal, this.low)) : new TasksResult(build, project, this.high, this.normal, this.low);
        HealthReportBuilder healthReportBuilder = this.createHealthReporter(Messages.Tasks_ResultAction_HealthReportSingleItem(), Messages.Tasks_ResultAction_HealthReportMultipleItem("%d"));
        build.getActions().add(new TasksResultAction(build, result, healthReportBuilder));
        int warnings = project.getNumberOfAnnotations();
        if (warnings > 0) {
            listener.getLogger().println("A total of " + warnings + " open tasks have been found.");
            if (this.isThresholdEnabled() && warnings >= this.getMinimumAnnotations()) {
                build.setResult(Result.UNSTABLE);
            }
        } else {
            listener.getLogger().println("No open tasks have been found.");
        }
        return true;
    }

    public Descriptor<Publisher> getDescriptor() {
        return TASK_SCANNER_DESCRIPTOR;
    }
}

