/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.tasks.util.model;

import edu.umd.cs.findbugs.annotations.SuppressWarnings;
import hudson.plugins.tasks.util.model.AnnotationContainer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.NoSuchElementException;
import org.apache.commons.lang.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WorkspaceFile
extends AnnotationContainer {
    private static final long serialVersionUID = 601361940925156719L;
    private String name;
    @SuppressWarnings(value={"Se"})
    private final List<WorkspaceFile> files;

    public WorkspaceFile(String fileName) {
        super(false, fileName.replace('\\', '/'));
        ArrayList<WorkspaceFile> singleFile = new ArrayList<WorkspaceFile>();
        singleFile.add(this);
        this.files = Collections.unmodifiableList(singleFile);
    }

    public String getShortName() {
        return StringUtils.substringAfterLast((String)this.getName(), (String)"/");
    }

    private Object readResolve() {
        this.rebuildMappings(false);
        if (this.name != null) {
            this.setName(this.name);
        }
        return this;
    }

    public Collection<WorkspaceFile> getFiles() {
        return this.files;
    }

    public WorkspaceFile getFile(String fileName) {
        if (this.getName().equals(fileName)) {
            return this;
        }
        throw new NoSuchElementException("File not found: " + fileName);
    }
}

