/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.tasks;

import com.thoughtworks.xstream.XStream;
import edu.umd.cs.findbugs.annotations.SuppressWarnings;
import hudson.XmlFile;
import hudson.model.AbstractBuild;
import hudson.model.ModelObject;
import hudson.plugins.tasks.ResultSummary;
import hudson.plugins.tasks.TasksModuleDetail;
import hudson.plugins.tasks.TasksPackageDetail;
import hudson.plugins.tasks.TasksPrioritiesDetail;
import hudson.plugins.tasks.parser.Task;
import hudson.plugins.tasks.parser.TasksProject;
import hudson.plugins.tasks.util.ChartRenderer;
import hudson.plugins.tasks.util.Messages;
import hudson.plugins.tasks.util.PrioritiesDetail;
import hudson.plugins.tasks.util.PriorityDetailFactory;
import hudson.plugins.tasks.util.SourceDetail;
import hudson.plugins.tasks.util.model.AnnotationContainer;
import hudson.plugins.tasks.util.model.AnnotationProvider;
import hudson.plugins.tasks.util.model.AnnotationStream;
import hudson.plugins.tasks.util.model.DefaultAnnotationContainer;
import hudson.plugins.tasks.util.model.FileAnnotation;
import hudson.plugins.tasks.util.model.JavaPackage;
import hudson.plugins.tasks.util.model.MavenModule;
import hudson.plugins.tasks.util.model.Priority;
import hudson.plugins.tasks.util.model.WorkspaceFile;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.commons.lang.StringUtils;
import org.kohsuke.stapler.StaplerRequest;
import org.kohsuke.stapler.StaplerResponse;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@SuppressWarnings(value={"PMD.TooManyFields"})
public class TasksResult
implements ModelObject,
Serializable,
AnnotationProvider {
    private static final long serialVersionUID = -344808345805935004L;
    private static final Logger LOGGER = Logger.getLogger(TasksResult.class.getName());
    private static final XStream XSTREAM = new AnnotationStream();
    @SuppressWarnings(value={"Se"})
    private transient WeakReference<TasksProject> project;
    @SuppressWarnings(value={"Se"})
    private final AbstractBuild<?, ?> owner;
    private final String high;
    private final String normal;
    private final String low;
    private final int numberOfTasks;
    private final int delta;
    private final int highPriorityTasks;
    private final int lowPriorityTasks;
    private final int normalPriorityTasks;
    private final int numberOfFiles;

    public TasksResult(AbstractBuild<?, ?> build, TasksProject project, String high, String normal, String low) {
        this(build, project, project.getNumberOfAnnotations(), high, normal, low);
    }

    public TasksResult(AbstractBuild<?, ?> build, TasksProject project, int previousNumberOfTasks, String high, String normal, String low) {
        this.owner = build;
        this.highPriorityTasks = project.getNumberOfAnnotations(Priority.HIGH);
        this.lowPriorityTasks = project.getNumberOfAnnotations(Priority.LOW);
        this.normalPriorityTasks = project.getNumberOfAnnotations(Priority.NORMAL);
        this.high = high;
        this.normal = normal;
        this.low = low;
        this.numberOfTasks = project.getNumberOfAnnotations();
        this.delta = this.numberOfTasks - previousNumberOfTasks;
        this.numberOfFiles = project.getNumberOfScannedFiles();
        this.project = new WeakReference<TasksProject>(project);
        try {
            Collection<FileAnnotation> files = project.getAnnotations();
            this.getDataFile().write((Object)files.toArray(new FileAnnotation[files.size()]));
        }
        catch (IOException exception) {
            LOGGER.log(Level.WARNING, "Failed to serialize the open tasks result.", exception);
        }
    }

    public String getSummary() {
        return ResultSummary.createSummary(this);
    }

    public final boolean isCurrent() {
        return ((AbstractBuild)this.owner.getProject().getLastBuild()).number == this.owner.number;
    }

    public final AbstractBuild<?, ?> getOwner() {
        return this.owner;
    }

    public int getNumberOfFiles() {
        return this.numberOfFiles;
    }

    @Override
    public int getNumberOfAnnotations() {
        return this.numberOfTasks;
    }

    @Override
    public int getNumberOfAnnotations(Priority priority) {
        if (priority == Priority.HIGH) {
            return this.highPriorityTasks;
        }
        if (priority == Priority.NORMAL) {
            return this.normalPriorityTasks;
        }
        return this.lowPriorityTasks;
    }

    public String getDisplayName() {
        return hudson.plugins.tasks.Messages.Tasks_ProjectAction_Name();
    }

    public int getDelta() {
        return this.delta;
    }

    public Collection<JavaPackage> getPackages() {
        return this.getProject().getPackages();
    }

    public synchronized TasksProject getProject() {
        AnnotationProvider result;
        if (this.project == null) {
            this.loadResult();
        }
        if ((result = (AnnotationProvider)this.project.get()) == null) {
            this.loadResult();
        }
        return (TasksProject)this.project.get();
    }

    private void loadResult() {
        TasksProject result;
        try {
            TasksProject newProject = new TasksProject(this.numberOfFiles);
            FileAnnotation[] annotations = (FileAnnotation[])this.getDataFile().read();
            newProject.addAnnotations(annotations);
            LOGGER.log(Level.INFO, "Loaded tasks data file " + this.getDataFile() + " for build " + this.getOwner().getNumber());
            result = newProject;
        }
        catch (IOException exception) {
            LOGGER.log(Level.WARNING, "Failed to load " + this.getDataFile(), exception);
            result = new TasksProject();
        }
        this.project = new WeakReference<TasksProject>(result);
    }

    private XmlFile getDataFile() {
        return new XmlFile(XSTREAM, new File(this.getOwner().getRootDir(), "open-tasks.xml"));
    }

    public Object getDynamic(String link, StaplerRequest request, StaplerResponse response) {
        PriorityDetailFactory factory = new PriorityDetailFactory(){

            @Override
            @SuppressWarnings(value={"IMA"})
            protected PrioritiesDetail createPrioritiesDetail(Priority priority, AbstractBuild<?, ?> build, AnnotationContainer container, String header) {
                return new TasksPrioritiesDetail(build, TasksResult.this.getProject(), priority, header, TasksResult.this.high, TasksResult.this.normal, TasksResult.this.low);
            }
        };
        if (factory.isPriority(link)) {
            return factory.create(link, this.owner, this.getProject(), this.getDisplayName());
        }
        if (link.startsWith("module.")) {
            return new TasksModuleDetail(this.getOwner(), this.getModule(StringUtils.substringAfter((String)link, (String)"module.")), this.getDisplayName(), this.high, this.normal, this.low);
        }
        if (link.startsWith("package.")) {
            return new TasksPackageDetail(this.getOwner(), this.getProject().getPackage(StringUtils.substringAfter((String)link, (String)"package.")), this.getDisplayName(), this.high, this.normal, this.low);
        }
        if (link.startsWith("source.")) {
            return new SourceDetail(this.getOwner(), this.getProject().getAnnotation(StringUtils.substringAfter((String)link, (String)"source.")));
        }
        return null;
    }

    public AnnotationContainer getContainer() {
        return this.getProject();
    }

    public MavenModule getModule(String name) {
        return this.getProject().getModule(name);
    }

    public List<String> getPriorities() {
        ArrayList<String> actualPriorities = new ArrayList<String>();
        for (String priority : this.getAvailablePriorities()) {
            if (this.getNumberOfAnnotations(priority) <= 0) continue;
            actualPriorities.add(priority);
        }
        return actualPriorities;
    }

    public Collection<String> getAvailablePriorities() {
        ArrayList<String> priorities = new ArrayList<String>();
        if (StringUtils.isNotEmpty((String)this.high)) {
            priorities.add(StringUtils.capitalize((String)StringUtils.lowerCase((String)Priority.HIGH.name())));
        }
        if (StringUtils.isNotEmpty((String)this.normal)) {
            priorities.add(StringUtils.capitalize((String)StringUtils.lowerCase((String)Priority.NORMAL.name())));
        }
        if (StringUtils.isNotEmpty((String)this.low)) {
            priorities.add(StringUtils.capitalize((String)StringUtils.lowerCase((String)Priority.LOW.name())));
        }
        return priorities;
    }

    public String getLocalizedPriority(String priorityName) {
        return Priority.fromString(priorityName).getLongLocalizedString();
    }

    public final String getTags(String priority) {
        return this.getTags(Priority.fromString(priority));
    }

    public final String getTags(Priority priority) {
        if (priority == Priority.HIGH) {
            return this.high;
        }
        if (priority == Priority.NORMAL) {
            return this.normal;
        }
        return this.low;
    }

    public String getPackageCategoryName() {
        String fileName;
        if (this.hasAnnotations() && (fileName = this.getAnnotations().iterator().next().getFileName()).endsWith(".cs")) {
            return Messages.NamespaceDetail_header();
        }
        return Messages.PackageDetail_header();
    }

    public final void doStatistics(StaplerRequest request, StaplerResponse response) throws IOException {
        String parameter = request.getParameter("object");
        if (parameter.startsWith("category.")) {
            Set<FileAnnotation> annotations = this.getProject().getCategory(StringUtils.substringAfter((String)parameter, (String)"category."));
            ChartRenderer.renderPriorititesChart(request, response, new DefaultAnnotationContainer(annotations), this.getProject().getAnnotationBound());
        } else if (parameter.startsWith("type.")) {
            Set<FileAnnotation> annotations = this.getProject().getType(StringUtils.substringAfter((String)parameter, (String)"type."));
            ChartRenderer.renderPriorititesChart(request, response, new DefaultAnnotationContainer(annotations), this.getProject().getAnnotationBound());
        } else if (parameter.startsWith("package.")) {
            JavaPackage annotations = this.getProject().getPackage(StringUtils.substringAfter((String)parameter, (String)"package."));
            ChartRenderer.renderPriorititesChart(request, response, annotations, this.getProject().getAnnotationBound());
        } else if (parameter.startsWith("module.")) {
            MavenModule annotations = this.getModule(StringUtils.substringAfter((String)parameter, (String)"module."));
            ChartRenderer.renderPriorititesChart(request, response, annotations, this.getProject().getAnnotationBound());
        }
    }

    public Collection<WorkspaceFile> getFiles() {
        return this.getProject().getFiles();
    }

    @Override
    public FileAnnotation getAnnotation(long key) {
        return this.getProject().getAnnotation(key);
    }

    @Override
    public FileAnnotation getAnnotation(String key) {
        return this.getProject().getAnnotation(key);
    }

    @Override
    public Collection<FileAnnotation> getAnnotations(Priority priority) {
        return this.getProject().getAnnotations(priority);
    }

    @Override
    public Collection<FileAnnotation> getAnnotations(String priority) {
        return this.getProject().getAnnotations(priority);
    }

    @Override
    public boolean hasAnnotations(Priority priority) {
        return this.getProject().hasAnnotations(priority);
    }

    @Override
    public boolean hasAnnotations(String priority) {
        return this.getProject().hasAnnotations(priority);
    }

    @Override
    public final boolean hasAnnotations() {
        return this.getProject().hasAnnotations();
    }

    @Override
    public Collection<FileAnnotation> getAnnotations() {
        return this.getProject().getAnnotations();
    }

    @Override
    public int getNumberOfAnnotations(String priority) {
        return this.getNumberOfAnnotations(Priority.fromString(priority));
    }

    static {
        XSTREAM.alias("task", Task.class);
    }
}

