/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.tasks.parser;

import hudson.FilePath;
import hudson.plugins.tasks.parser.Task;
import hudson.plugins.tasks.parser.TaskScanner;
import hudson.plugins.tasks.parser.TasksProject;
import hudson.plugins.tasks.util.CsharpNamespaceDetector;
import hudson.plugins.tasks.util.JavaPackageDetector;
import hudson.plugins.tasks.util.ModuleDetector;
import hudson.plugins.tasks.util.PackageDetector;
import hudson.remoting.VirtualChannel;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.commons.lang.StringUtils;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.types.FileSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WorkspaceScanner
implements FilePath.FileCallable<TasksProject> {
    private static final long serialVersionUID = -4355362392102020724L;
    private final String filePattern;
    private final String excludeFilePattern;
    private String moduleName;
    private final String high;
    private final String normal;
    private final String low;
    private String prefix;

    public WorkspaceScanner(String filePattern, String excludeFilePattern, String high, String normal, String low) {
        this.filePattern = filePattern;
        this.excludeFilePattern = excludeFilePattern;
        this.high = high;
        this.normal = normal;
        this.low = low;
    }

    public WorkspaceScanner(String filePattern, String excludeFilePattern, String high, String normal, String low, String moduleName) {
        this(filePattern, excludeFilePattern, high, normal, low);
        this.moduleName = moduleName;
    }

    public void setPrefix(String prefix) {
        this.prefix = prefix + "/";
    }

    public String getPrefix() {
        return StringUtils.defaultIfEmpty((String)this.prefix, (String)"");
    }

    public TasksProject invoke(File workspace, VirtualChannel channel) throws IOException {
        String[] files = this.findFiles(workspace);
        ArrayList<PackageDetector> detectors = new ArrayList<PackageDetector>();
        detectors.add(new JavaPackageDetector());
        detectors.add(new CsharpNamespaceDetector());
        TaskScanner taskScanner = new TaskScanner(this.high, this.normal, this.low);
        TasksProject javaProject = new TasksProject(files.length);
        ModuleDetector moduleDetector = new ModuleDetector();
        Map<String, String> pathNameToModuleMapping = moduleDetector.getModules(workspace);
        for (String fileName : files) {
            File originalFile = new File(workspace, fileName);
            Collection<Task> tasks = taskScanner.scan(new FilePath(originalFile).read());
            if (tasks.isEmpty()) continue;
            String unixName = fileName.replace('\\', '/');
            String packageName = this.detectPackageName(detectors, unixName, new FilePath(originalFile).read());
            String guessedModule = this.guessModuleName(pathNameToModuleMapping, originalFile);
            String actualModule = StringUtils.defaultIfEmpty((String)this.moduleName, (String)guessedModule);
            for (Task task : tasks) {
                task.setFileName(this.getPrefix() + unixName);
                task.setPackageName(packageName);
                task.setModuleName(actualModule);
            }
            javaProject.addAnnotations(tasks);
        }
        return javaProject;
    }

    private String guessModuleName(Map<String, String> pathNameToModuleMapping, File originalFile) {
        ArrayList<String> prefixes = new ArrayList<String>(pathNameToModuleMapping.keySet());
        Collections.sort(prefixes);
        String fullPath = originalFile.getAbsolutePath().replace('\\', '/');
        String guessedModule = "";
        for (String path : prefixes) {
            if (!fullPath.startsWith(path)) continue;
            Logger.getLogger(WorkspaceScanner.class.getName()).log(Level.WARNING, "TREFFER!");
            guessedModule = pathNameToModuleMapping.get(path);
        }
        return guessedModule;
    }

    private String detectPackageName(List<PackageDetector> detectors, String fileName, InputStream content) throws IOException {
        for (PackageDetector detector : detectors) {
            if (!detector.accepts(fileName)) continue;
            return detector.detectPackageName(content);
        }
        return "n/a";
    }

    private String[] findFiles(File workspaceRoot) {
        FileSet fileSet = new FileSet();
        Project project = new Project();
        fileSet.setProject(project);
        fileSet.setDir(workspaceRoot);
        fileSet.setIncludes(this.filePattern);
        if (StringUtils.isNotBlank((String)this.excludeFilePattern)) {
            fileSet.setExcludes(this.excludeFilePattern);
        }
        return fileSet.getDirectoryScanner(project).getIncludedFiles();
    }
}

