/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.tasks;

import hudson.model.AbstractBuild;
import hudson.plugins.tasks.ResultSummary;
import hudson.plugins.tasks.TasksDetailBuilder;
import hudson.plugins.tasks.TasksResultAction;
import hudson.plugins.tasks.parser.Task;
import hudson.plugins.tasks.parser.TasksParserResult;
import hudson.plugins.tasks.util.BuildResult;
import hudson.plugins.tasks.util.Messages;
import hudson.plugins.tasks.util.ParserResult;
import hudson.plugins.tasks.util.ResultAction;
import hudson.plugins.tasks.util.model.FileAnnotation;
import hudson.plugins.tasks.util.model.Priority;
import java.util.ArrayList;
import org.apache.commons.lang.StringUtils;
import org.kohsuke.stapler.StaplerRequest;
import org.kohsuke.stapler.StaplerResponse;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TasksResult
extends BuildResult {
    private static final long serialVersionUID = -344808345805935004L;
    private final String highTags;
    private final String normalTags;
    private final String lowTags;
    private final int numberOfFiles;
    @Deprecated
    private transient int numberOfTasks;
    @Deprecated
    private transient int highPriorityTasks;
    @Deprecated
    private transient int lowPriorityTasks;
    @Deprecated
    private transient int normalPriorityTasks;

    public TasksResult(AbstractBuild<?, ?> build, String defaultEncoding, TasksParserResult result, String highTags, String normalTags, String lowTags) {
        super(build, defaultEncoding, (ParserResult)result);
        this.highTags = highTags;
        this.normalTags = normalTags;
        this.lowTags = lowTags;
        this.numberOfFiles = result.getNumberOfScannedFiles();
    }

    public TasksResult(AbstractBuild<?, ?> build, String defaultEncoding, TasksParserResult result, BuildResult previous, String highTags, String normalTags, String lowTags) {
        super(build, defaultEncoding, (ParserResult)result, previous);
        this.highTags = highTags;
        this.normalTags = normalTags;
        this.lowTags = lowTags;
        this.numberOfFiles = result.getNumberOfScannedFiles();
    }

    public String getSummary() {
        return ResultSummary.createSummary((TasksResult)this);
    }

    public int getNumberOfFiles() {
        return this.numberOfFiles;
    }

    public String getDisplayName() {
        return hudson.plugins.tasks.Messages.Tasks_ProjectAction_Name();
    }

    protected String getSerializationFileName() {
        return "open-tasks.xml";
    }

    public Object getDynamic(String link, StaplerRequest request, StaplerResponse response) {
        return new TasksDetailBuilder().getDynamic(link, this.getOwner(), this.getContainer(), this.getFixedWarnings(), this.getNewWarnings(), this.getErrors(), this.getDefaultEncoding(), this.getDisplayName(), this.getTags(Priority.HIGH), this.getTags(Priority.NORMAL), this.getTags(Priority.LOW));
    }

    public Priority[] getPriorities() {
        ArrayList<Priority> priorities = new ArrayList<Priority>();
        if (StringUtils.isNotEmpty((String)this.highTags)) {
            priorities.add(Priority.HIGH);
        }
        if (StringUtils.isNotEmpty((String)this.normalTags)) {
            priorities.add(Priority.NORMAL);
        }
        if (StringUtils.isNotEmpty((String)this.lowTags)) {
            priorities.add(Priority.LOW);
        }
        return priorities.toArray(new Priority[priorities.size()]);
    }

    public final String getTags(Priority priority) {
        if (priority == Priority.HIGH) {
            return this.highTags;
        }
        if (priority == Priority.NORMAL) {
            return this.normalTags;
        }
        return this.lowTags;
    }

    public String getPackageCategoryName() {
        String fileName;
        if (this.hasAnnotations() && (fileName = ((FileAnnotation)this.getAnnotations().iterator().next()).getFileName()).endsWith(".cs")) {
            return Messages.NamespaceDetail_header();
        }
        return Messages.PackageDetail_header();
    }

    protected Class<? extends ResultAction<? extends BuildResult>> getResultActionType() {
        return TasksResultAction.class;
    }

    public String getDetails() {
        return "";
    }

    static {
        XSTREAM.alias("task", Task.class);
    }
}

