/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.tasks.util;

import hudson.model.AbstractBuild;
import hudson.model.Hudson;
import hudson.plugins.tasks.util.AttributeDetail;
import hudson.plugins.tasks.util.ErrorDetail;
import hudson.plugins.tasks.util.FileDetail;
import hudson.plugins.tasks.util.FixedWarningsDetail;
import hudson.plugins.tasks.util.Messages;
import hudson.plugins.tasks.util.ModuleDetail;
import hudson.plugins.tasks.util.NewWarningsDetail;
import hudson.plugins.tasks.util.PackageDetail;
import hudson.plugins.tasks.util.PriorityDetailFactory;
import hudson.plugins.tasks.util.SourceDetail;
import hudson.plugins.tasks.util.TabDetail;
import hudson.plugins.tasks.util.model.AnnotationContainer;
import hudson.plugins.tasks.util.model.DefaultAnnotationContainer;
import hudson.plugins.tasks.util.model.FileAnnotation;
import java.util.Collection;
import org.apache.commons.lang.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DetailBuilder {
    private static final Class<DetailBuilder> DEFAULT_DETAIL_BUILDER = DetailBuilder.class;
    private static Class<? extends DetailBuilder> detailBuilder = DEFAULT_DETAIL_BUILDER;

    public static DetailBuilder create() {
        try {
            return (DetailBuilder)detailBuilder.newInstance();
        }
        catch (InstantiationException exception) {
        }
        catch (IllegalAccessException illegalAccessException) {
            // empty catch block
        }
        return new DetailBuilder();
    }

    public static void setDetailBuilder(Class<? extends DetailBuilder> detailBuilder) {
        DetailBuilder.detailBuilder = detailBuilder;
    }

    public Object createTrendDetails(String link, AbstractBuild<?, ?> owner, AnnotationContainer container, Collection<FileAnnotation> fixedAnnotations, Collection<FileAnnotation> newAnnotations, Collection<String> errors, String defaultEncoding, String displayName) {
        if ("fixed".equals(link)) {
            return new FixedWarningsDetail(owner, fixedAnnotations, defaultEncoding, displayName);
        }
        if ("new".equals(link)) {
            return new NewWarningsDetail(owner, newAnnotations, defaultEncoding, displayName);
        }
        if ("error".equals(link)) {
            return new ErrorDetail(owner, errors);
        }
        if (link.startsWith("tab.new")) {
            return new TabDetail(owner, newAnnotations, "/tabview/new.jelly", defaultEncoding);
        }
        if (link.startsWith("tab.fixed")) {
            return new TabDetail(owner, fixedAnnotations, "/tabview/fixed.jelly", defaultEncoding);
        }
        return this.createDetails(link, owner, container, defaultEncoding, displayName);
    }

    public Object createDetails(String link, AbstractBuild<?, ?> owner, AnnotationContainer container, String defaultEncoding, String displayName) {
        PriorityDetailFactory factory = new PriorityDetailFactory();
        if (factory.isPriority(link)) {
            return factory.create(link, owner, container, defaultEncoding, displayName);
        }
        if (link.startsWith("module.")) {
            return new ModuleDetail(owner, container.getModule(this.createHashCode(link, "module.")), defaultEncoding, displayName);
        }
        if (link.startsWith("package.")) {
            return new PackageDetail(owner, container.getPackage(this.createHashCode(link, "package.")), defaultEncoding, displayName);
        }
        if (link.startsWith("file.")) {
            return new FileDetail(owner, container.getFile(this.createHashCode(link, "file.")), defaultEncoding, displayName);
        }
        if (link.startsWith("tab.")) {
            return new TabDetail(owner, container.getAnnotations(), "/tabview/" + StringUtils.substringAfter((String)link, (String)"tab.") + ".jelly", defaultEncoding);
        }
        if (link.startsWith("source.")) {
            owner.checkPermission(Hudson.ADMINISTER);
            return new SourceDetail(owner, container.getAnnotation(StringUtils.substringAfter((String)link, (String)"source.")), defaultEncoding);
        }
        if (link.startsWith("category.")) {
            DefaultAnnotationContainer category = container.getCategory(this.createHashCode(link, "category."));
            return new AttributeDetail(owner, category.getAnnotations(), defaultEncoding, displayName, Messages.CategoryDetail_header() + " " + category.getName());
        }
        if (link.startsWith("type.")) {
            DefaultAnnotationContainer type = container.getType(this.createHashCode(link, "type."));
            return new AttributeDetail(owner, type.getAnnotations(), defaultEncoding, displayName, Messages.TypeDetail_header() + " " + type.getName());
        }
        return null;
    }

    private int createHashCode(String link, String prefix) {
        return Integer.parseInt(StringUtils.substringAfter((String)link, (String)prefix));
    }

    protected DetailBuilder() {
    }
}

