/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.tasks.util;

import edu.umd.cs.findbugs.annotations.SuppressWarnings;
import hudson.model.HealthReport;
import hudson.plugins.tasks.util.AbstractHealthDescriptor;
import hudson.plugins.tasks.util.model.AnnotationProvider;
import hudson.plugins.tasks.util.model.Priority;
import java.io.Serializable;

public class HealthReportBuilder
implements Serializable {
    private static final long serialVersionUID = 5191317904662711835L;
    private final AbstractHealthDescriptor healthDescriptor;
    @Deprecated
    @SuppressWarnings(value={"SE"})
    private transient int healthy;
    @Deprecated
    @SuppressWarnings(value={"SE"})
    private transient int unHealthy;
    @Deprecated
    @SuppressWarnings(value={"SE"})
    private transient boolean isHealthEnabled;
    @Deprecated
    @SuppressWarnings(value={"SE"})
    private transient boolean isThresholdEnabled;
    @Deprecated
    @SuppressWarnings(value={"SE"})
    private transient int threshold;
    @Deprecated
    @SuppressWarnings(value={"SE"})
    private transient String reportName;
    @Deprecated
    @SuppressWarnings(value={"SE"})
    private transient String itemName;
    @Deprecated
    @SuppressWarnings(value={"SE"})
    private transient String reportSingleCount;
    @Deprecated
    @SuppressWarnings(value={"SE"})
    private transient String reportMultipleCount;

    public HealthReportBuilder(AbstractHealthDescriptor healthDescriptor) {
        this.healthDescriptor = healthDescriptor;
    }

    public HealthReport computeHealth(AnnotationProvider result) {
        int numberOfAnnotations = 0;
        for (Priority priority : Priority.collectPrioritiesFrom((Priority)this.healthDescriptor.getMinimumPriority())) {
            numberOfAnnotations += result.getNumberOfAnnotations(priority);
        }
        return this.computeHealth(numberOfAnnotations, result);
    }

    protected HealthReport computeHealth(int counter, AnnotationProvider result) {
        if (this.healthDescriptor.isHealthyReportEnabled()) {
            int percentage = counter < this.healthDescriptor.getHealthyAnnotations() ? 100 : (counter > this.healthDescriptor.getUnHealthyAnnotations() ? 0 : 100 - (counter - this.healthDescriptor.getHealthyAnnotations()) * 100 / (this.healthDescriptor.getUnHealthyAnnotations() - this.healthDescriptor.getHealthyAnnotations()));
            return new HealthReport(percentage, this.healthDescriptor.createDescription(result));
        }
        return null;
    }
}

