/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.tasks;

import hudson.FilePath;
import hudson.model.AbstractBuild;
import hudson.model.AbstractProject;
import hudson.model.Action;
import hudson.model.Descriptor;
import hudson.model.Result;
import hudson.plugins.tasks.TasksDescriptor;
import hudson.plugins.tasks.TasksProjectAction;
import hudson.plugins.tasks.TasksResult;
import hudson.plugins.tasks.TasksResultAction;
import hudson.plugins.tasks.TasksResultBuilder;
import hudson.plugins.tasks.parser.TasksParserResult;
import hudson.plugins.tasks.parser.WorkspaceScanner;
import hudson.plugins.tasks.util.BuildResult;
import hudson.plugins.tasks.util.HealthAwarePublisher;
import hudson.plugins.tasks.util.PluginLogger;
import hudson.tasks.Publisher;
import java.io.IOException;
import org.apache.commons.lang.StringUtils;
import org.kohsuke.stapler.DataBoundConstructor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TasksPublisher
extends HealthAwarePublisher {
    private static final long serialVersionUID = 3787892530045641806L;
    private static final String DEFAULT_PATTERN = "**/*.java";
    public static final TasksDescriptor TASK_SCANNER_DESCRIPTOR = new TasksDescriptor();
    private final String high;
    private final String normal;
    private final String low;
    private final boolean ignoreCase;
    private final String pattern;
    private final String excludePattern;
    private final boolean canRunOnFailed;

    @DataBoundConstructor
    public TasksPublisher(String pattern, String excludePattern, String threshold, String newThreshold, String failureThreshold, String newFailureThreshold, String healthy, String unHealthy, String thresholdLimit, String high, String normal, String low, boolean ignoreCase, String defaultEncoding, boolean canRunOnFailed) {
        super(threshold, newThreshold, failureThreshold, newFailureThreshold, healthy, unHealthy, thresholdLimit, defaultEncoding, "TASKS");
        this.canRunOnFailed = canRunOnFailed;
        this.pattern = pattern;
        this.excludePattern = excludePattern;
        this.high = high;
        this.normal = normal;
        this.low = low;
        this.ignoreCase = ignoreCase;
    }

    public boolean getCanRunOnFailed() {
        return this.canRunOnFailed;
    }

    @Override
    protected boolean canContinue(Result result) {
        if (this.canRunOnFailed) {
            return true;
        }
        return super.canContinue(result);
    }

    public String getPattern() {
        return this.pattern;
    }

    public String getExcludePattern() {
        return this.excludePattern;
    }

    public String getHigh() {
        return this.high;
    }

    public String getNormal() {
        return this.normal;
    }

    public String getLow() {
        return this.low;
    }

    public boolean getIgnoreCase() {
        return this.ignoreCase;
    }

    public Action getProjectAction(AbstractProject<?, ?> project) {
        return new TasksProjectAction(project);
    }

    @Override
    protected BuildResult perform(AbstractBuild<?, ?> build, PluginLogger logger) throws InterruptedException, IOException {
        logger.log("Scanning workspace files for tasks...");
        TasksParserResult project = (TasksParserResult)build.getProject().getWorkspace().act((FilePath.FileCallable)new WorkspaceScanner(StringUtils.defaultIfEmpty((String)this.getPattern(), (String)DEFAULT_PATTERN), this.getExcludePattern(), this.getDefaultEncoding(), this.high, this.normal, this.low, this.ignoreCase));
        TasksResult result = new TasksResultBuilder().build(build, project, this.getDefaultEncoding(), this.high, this.normal, this.low);
        build.getActions().add(new TasksResultAction(build, this, result));
        return result;
    }

    public Descriptor<Publisher> getDescriptor() {
        return TASK_SCANNER_DESCRIPTOR;
    }
}

