/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.tasks.util;

import hudson.plugins.tasks.util.Messages;
import hudson.plugins.tasks.util.SingleFieldValidator;
import java.io.IOException;
import javax.servlet.ServletException;
import org.apache.commons.lang.StringUtils;
import org.kohsuke.stapler.StaplerRequest;
import org.kohsuke.stapler.StaplerResponse;

public class ThresholdValidator
extends SingleFieldValidator {
    public ThresholdValidator(StaplerRequest request, StaplerResponse response) {
        super(request, response);
    }

    public void check(String value) throws IOException, ServletException {
        if (!StringUtils.isEmpty((String)value)) {
            try {
                int integer = Integer.valueOf(value);
                if (integer < 0) {
                    this.error(Messages.FieldValidator_Error_Threshold());
                    return;
                }
            }
            catch (NumberFormatException exception) {
                this.error(Messages.FieldValidator_Error_Threshold());
                return;
            }
        }
        this.ok();
    }
}

