/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.tasks.parser;

import hudson.plugins.tasks.parser.Task;
import hudson.plugins.tasks.util.AbortException;
import hudson.plugins.tasks.util.model.Priority;
import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.apache.commons.io.IOUtils;
import org.apache.commons.io.LineIterator;
import org.apache.commons.lang.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TaskScanner {
    private final Map<Priority, Pattern> patterns = new HashMap<Priority, Pattern>();

    public TaskScanner() {
        this("FIXME", "TODO", "@deprecated");
    }

    public TaskScanner(String high, String normal, String low) {
        if (StringUtils.isNotBlank((String)high)) {
            this.patterns.put(Priority.HIGH, this.compile(high));
        }
        if (StringUtils.isNotBlank((String)normal)) {
            this.patterns.put(Priority.NORMAL, this.compile(normal));
        }
        if (StringUtils.isNotBlank((String)low)) {
            this.patterns.put(Priority.LOW, this.compile(low));
        }
    }

    private Pattern compile(String tagIdentifiers) {
        try {
            String[] tags = tagIdentifiers.indexOf(44) == -1 ? new String[]{tagIdentifiers} : StringUtils.split((String)tagIdentifiers, (String)",");
            ArrayList<String> regexps = new ArrayList<String>();
            for (int i = 0; i < tags.length; ++i) {
                String tag = tags[i].trim();
                if (!StringUtils.isNotBlank((String)tag)) continue;
                if (Character.isLetterOrDigit(tag.charAt(0))) {
                    regexps.add("\\b" + tag + "\\b");
                    continue;
                }
                regexps.add(tag + "\\b");
            }
            return Pattern.compile("^.*(?:" + StringUtils.join(regexps.iterator(), (String)"|") + ")(.*)$");
        }
        catch (PatternSyntaxException exception) {
            throw new AbortException("Invalid identifiers in a regular expression: " + tagIdentifiers + "\n", exception);
        }
    }

    public Collection<Task> scan(Reader reader) throws IOException {
        LineIterator lineIterator = IOUtils.lineIterator((Reader)reader);
        ArrayList<Task> tasks = new ArrayList<Task>();
        int lineNumber = 1;
        while (lineIterator.hasNext()) {
            String line = (String)lineIterator.next();
            for (Priority priority : Priority.values()) {
                Matcher matcher;
                if (!this.patterns.containsKey((Object)priority) || !(matcher = this.patterns.get((Object)priority).matcher(line)).matches() || matcher.groupCount() != 1) continue;
                String message = matcher.group(1).trim();
                tasks.add(new Task(priority, lineNumber, StringUtils.remove((String)message, (String)":").trim()));
            }
            ++lineNumber;
        }
        reader.close();
        return tasks;
    }
}

