/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.tasks;

import hudson.maven.AggregatableAction;
import hudson.maven.MavenAggregatedReport;
import hudson.maven.MavenBuild;
import hudson.maven.MavenModule;
import hudson.maven.MavenModuleSet;
import hudson.maven.MavenModuleSetBuild;
import hudson.model.AbstractBuild;
import hudson.model.AbstractProject;
import hudson.model.Action;
import hudson.plugins.tasks.TasksMavenResult;
import hudson.plugins.tasks.TasksProjectAction;
import hudson.plugins.tasks.TasksResult;
import hudson.plugins.tasks.TasksResultAction;
import hudson.plugins.tasks.TasksResultBuilder;
import hudson.plugins.tasks.parser.TasksParserResult;
import hudson.plugins.tasks.util.BuildResult;
import hudson.plugins.tasks.util.HealthDescriptor;
import hudson.plugins.tasks.util.ParserResult;
import hudson.plugins.tasks.util.TrendReportHeightValidator;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MavenTasksResultAction
extends TasksResultAction
implements AggregatableAction,
MavenAggregatedReport {
    private static final long serialVersionUID = 1273798369273225973L;
    private String height;
    private String high;
    private String normal;
    private String low;
    private String defaultEncoding;

    public MavenTasksResultAction(AbstractBuild<?, ?> owner, HealthDescriptor healthDescriptor, String height, String defaultEncoding, String high, String normal, String low, TasksResult result) {
        super(owner, healthDescriptor, result);
        this.initializeFields(height, defaultEncoding, high, normal, low);
    }

    public MavenTasksResultAction(AbstractBuild<?, ?> owner, HealthDescriptor healthDescriptor, String height, String defaultEncoding, String high, String normal, String low) {
        super(owner, healthDescriptor);
        this.initializeFields(height, defaultEncoding, high, normal, low);
    }

    private void initializeFields(String height, String defaultEncoding, String high, String normal, String low) {
        this.height = height;
        this.high = high;
        this.normal = normal;
        this.low = low;
        this.defaultEncoding = defaultEncoding;
    }

    public MavenAggregatedReport createAggregatedAction(MavenModuleSetBuild build, Map<MavenModule, List<MavenBuild>> moduleBuilds) {
        return new MavenTasksResultAction((AbstractBuild)build, (HealthDescriptor)this.getHealthDescriptor(), this.height, this.defaultEncoding, this.high, this.normal, this.low);
    }

    public Action getProjectAction(MavenModuleSet moduleSet) {
        return new TasksProjectAction((AbstractProject)moduleSet, TrendReportHeightValidator.defaultHeight((String)this.height));
    }

    public Class<? extends AggregatableAction> getIndividualActionType() {
        return this.getClass();
    }

    public void update(Map<MavenModule, List<MavenBuild>> moduleBuilds, MavenBuild newBuild) {
        ParserResult result = this.createAggregatedResult(moduleBuilds);
        if (result instanceof TasksParserResult) {
            TasksMavenResult mavenResult = new TasksResultBuilder().buildMaven(this.getOwner(), (TasksParserResult)result, this.defaultEncoding, this.high, this.normal, this.low);
            this.setResult((BuildResult)mavenResult);
            this.updateBuildHealth(newBuild, (BuildResult)mavenResult);
        }
    }

    protected ParserResult createResult() {
        return new TasksParserResult();
    }
}

