/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.tasks.util;

import com.thoughtworks.xstream.XStream;
import edu.umd.cs.findbugs.annotations.SuppressWarnings;
import hudson.XmlFile;
import hudson.model.AbstractBuild;
import hudson.model.ModelObject;
import hudson.plugins.tasks.util.AnnotationDifferencer;
import hudson.plugins.tasks.util.DetailBuilder;
import hudson.plugins.tasks.util.ParserResult;
import hudson.plugins.tasks.util.ResultAction;
import hudson.plugins.tasks.util.model.AnnotationContainer;
import hudson.plugins.tasks.util.model.AnnotationProvider;
import hudson.plugins.tasks.util.model.AnnotationStream;
import hudson.plugins.tasks.util.model.FileAnnotation;
import hudson.plugins.tasks.util.model.JavaProject;
import hudson.plugins.tasks.util.model.MavenModule;
import hudson.plugins.tasks.util.model.Priority;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.kohsuke.stapler.StaplerRequest;
import org.kohsuke.stapler.StaplerResponse;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@SuppressWarnings(value={"PMD.TooManyFields"})
public abstract class BuildResult
implements ModelObject,
Serializable,
AnnotationProvider {
    private static final long serialVersionUID = 1110545450292087475L;
    protected static final XStream XSTREAM = new AnnotationStream();
    private static final Logger LOGGER = Logger.getLogger(BuildResult.class.getName());
    private AbstractBuild<?, ?> owner;
    private Set<String> modules;
    private int numberOfModules;
    private String defaultEncoding;
    @SuppressWarnings(value={"Se"})
    private transient WeakReference<JavaProject> project;
    @SuppressWarnings(value={"Se"})
    private transient WeakReference<Collection<FileAnnotation>> newWarnings;
    @SuppressWarnings(value={"Se"})
    private transient WeakReference<Collection<FileAnnotation>> fixedWarnings;
    private int numberOfWarnings;
    private int numberOfNewWarnings;
    private int numberOfFixedWarnings;
    private int delta;
    private int lowWarnings;
    private int normalWarnings;
    private int highWarnings;
    private int zeroWarningsSinceBuild;
    private long zeroWarningsSinceDate;
    private long zeroWarningsHighScore;
    private boolean isZeroWarningsHighscore;
    private long highScoreGap;
    @SuppressWarnings(value={"Se"})
    private List<String> errors;
    @Deprecated
    private transient Map<String, MavenModule> emptyModules;
    @Deprecated
    protected transient String low;
    @Deprecated
    protected transient String normal;
    @Deprecated
    protected transient String high;

    public static long getDays(long ms) {
        return Math.max(1L, ms / 86400000L);
    }

    public BuildResult(AbstractBuild<?, ?> build, String defaultEncoding, ParserResult result) {
        this.initialize(build, defaultEncoding, result, (AnnotationContainer)new JavaProject());
        if (result.hasNoAnnotations()) {
            this.zeroWarningsSinceBuild = build.getNumber();
            this.zeroWarningsSinceDate = build.getTimestamp().getTimeInMillis();
            this.isZeroWarningsHighscore = true;
        }
    }

    public BuildResult(AbstractBuild<?, ?> build, String defaultEncoding, ParserResult result, BuildResult previous) {
        JavaProject previousProject = previous.getProject();
        this.initialize(build, defaultEncoding, result, (AnnotationContainer)previousProject);
        if (result.hasNoAnnotations()) {
            if (previousProject.hasNoAnnotations()) {
                this.zeroWarningsSinceBuild = previous.getZeroWarningsSinceBuild();
                this.zeroWarningsSinceDate = previous.getZeroWarningsSinceDate();
            } else {
                this.zeroWarningsSinceBuild = build.getNumber();
                this.zeroWarningsSinceDate = build.getTimestamp().getTimeInMillis();
            }
            this.zeroWarningsHighScore = Math.max(previous.getZeroWarningsHighScore(), build.getTimestamp().getTimeInMillis() - this.zeroWarningsSinceDate);
            if (previous.getZeroWarningsHighScore() == 0L) {
                this.isZeroWarningsHighscore = true;
            } else {
                boolean bl = this.isZeroWarningsHighscore = this.zeroWarningsHighScore != previous.getZeroWarningsHighScore();
            }
            if (!this.isZeroWarningsHighscore) {
                this.highScoreGap = previous.getZeroWarningsHighScore() - (build.getTimestamp().getTimeInMillis() - this.zeroWarningsSinceDate);
            }
        } else {
            this.zeroWarningsHighScore = previous.getZeroWarningsHighScore();
        }
    }

    private void initialize(AbstractBuild<?, ?> build, String encoding, ParserResult result, AnnotationContainer previousProject) {
        this.owner = build;
        this.modules = new HashSet(result.getModules());
        this.numberOfModules = this.modules.size();
        this.errors = new ArrayList(result.getErrorMessages());
        this.defaultEncoding = encoding;
        this.numberOfWarnings = result.getNumberOfAnnotations();
        this.delta = result.getNumberOfAnnotations() - previousProject.getNumberOfAnnotations();
        Collection allWarnings = result.getAnnotations();
        Set warnings = AnnotationDifferencer.getNewAnnotations((Collection)allWarnings, (Collection)previousProject.getAnnotations());
        this.numberOfNewWarnings = warnings.size();
        this.newWarnings = new WeakReference<Set>(warnings);
        warnings = AnnotationDifferencer.getFixedAnnotations((Collection)allWarnings, (Collection)previousProject.getAnnotations());
        this.numberOfFixedWarnings = warnings.size();
        this.fixedWarnings = new WeakReference<Set>(warnings);
        this.highWarnings = result.getNumberOfAnnotations(Priority.HIGH);
        this.normalWarnings = result.getNumberOfAnnotations(Priority.NORMAL);
        this.lowWarnings = result.getNumberOfAnnotations(Priority.LOW);
        this.serializeAnnotations(result.getAnnotations());
        JavaProject container = new JavaProject();
        container.addAnnotations(result.getAnnotations());
        this.project = new WeakReference<JavaProject>(container);
    }

    public boolean hasError() {
        return !this.errors.isEmpty();
    }

    public List<String> getErrors() {
        return this.errors;
    }

    protected Object readResolve() {
        if (this.modules == null) {
            this.modules = new HashSet();
        }
        if (this.errors == null) {
            this.errors = new ArrayList();
        }
        try {
            if (this.low != null) {
                this.lowWarnings = Integer.valueOf(this.low);
            }
            if (this.normal != null) {
                this.normalWarnings = Integer.valueOf(this.normal);
            }
            if (this.high != null) {
                this.highWarnings = Integer.valueOf(this.high);
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return this;
    }

    public Collection<String> getModules() {
        return this.modules;
    }

    public int getNumberOfModules() {
        return this.numberOfModules;
    }

    public String getDefaultEncoding() {
        return this.defaultEncoding;
    }

    protected final XmlFile getDataFile() {
        return new XmlFile(XSTREAM, new File(this.getOwner().getRootDir(), this.getSerializationFileName()));
    }

    protected abstract String getSerializationFileName();

    public final boolean isCurrent() {
        return ((AbstractBuild)this.getOwner().getProject().getLastBuild()).number == this.getOwner().number;
    }

    public final AbstractBuild<?, ?> getOwner() {
        return this.owner;
    }

    public boolean hasAnnotations(Priority priority) {
        return this.getContainer().hasAnnotations(priority);
    }

    public boolean hasAnnotations(String priority) {
        return this.getContainer().hasAnnotations(priority);
    }

    public final boolean hasAnnotations() {
        return this.getContainer().hasAnnotations();
    }

    public boolean hasNoAnnotations() {
        return this.getContainer().hasNoAnnotations();
    }

    public boolean hasNoAnnotations(Priority priority) {
        return this.getContainer().hasAnnotations(priority);
    }

    public boolean hasNoAnnotations(String priority) {
        return this.getContainer().hasAnnotations(priority);
    }

    public Collection<FileAnnotation> getAnnotations() {
        return this.getContainer().getAnnotations();
    }

    public FileAnnotation getAnnotation(long key) {
        return this.getContainer().getAnnotation(key);
    }

    public FileAnnotation getAnnotation(String key) {
        return this.getContainer().getAnnotation(key);
    }

    protected void setHighWarnings(int highWarnings) {
        this.highWarnings = highWarnings;
    }

    protected void setNormalWarnings(int normalWarnings) {
        this.normalWarnings = normalWarnings;
    }

    protected void setLowWarnings(int lowWarnings) {
        this.lowWarnings = lowWarnings;
    }

    protected void setWarnings(int warnings) {
        this.numberOfWarnings = warnings;
    }

    public Collection<FileAnnotation> getAnnotations(Priority priority) {
        return this.getContainer().getAnnotations(priority);
    }

    private void serializeAnnotations(Collection<FileAnnotation> annotations) {
        try {
            Collection<FileAnnotation> files = annotations;
            this.getDataFile().write((Object)files.toArray(new FileAnnotation[files.size()]));
        }
        catch (IOException exception) {
            LOGGER.log(Level.SEVERE, "Failed to serialize the annotations of the build.", exception);
        }
    }

    public abstract String getDetails();

    public int getZeroWarningsSinceBuild() {
        return this.zeroWarningsSinceBuild;
    }

    public long getZeroWarningsSinceDate() {
        return this.zeroWarningsSinceDate;
    }

    public long getZeroWarningsHighScore() {
        return this.zeroWarningsHighScore;
    }

    public boolean isNewZeroWarningsHighScore() {
        return this.isZeroWarningsHighscore;
    }

    public long getHighScoreGap() {
        return this.highScoreGap;
    }

    public int getNumberOfAnnotations() {
        return this.numberOfWarnings;
    }

    public int getNumberOfAnnotations(Priority priority) {
        if (priority == Priority.HIGH) {
            return this.highWarnings;
        }
        if (priority == Priority.NORMAL) {
            return this.normalWarnings;
        }
        return this.lowWarnings;
    }

    public int getNumberOfFixedWarnings() {
        return this.numberOfFixedWarnings;
    }

    public int getNumberOfNewWarnings() {
        return this.numberOfNewWarnings;
    }

    public int getDelta() {
        return this.delta;
    }

    public synchronized JavaProject getProject() {
        if (this.project == null) {
            return this.loadResult();
        }
        JavaProject result = (JavaProject)this.project.get();
        if (result == null) {
            return this.loadResult();
        }
        return result;
    }

    private JavaProject loadResult() {
        JavaProject result;
        try {
            JavaProject newProject = new JavaProject();
            FileAnnotation[] annotations = (FileAnnotation[])this.getDataFile().read();
            newProject.addAnnotations(annotations);
            LOGGER.log(Level.INFO, "Loaded data file " + this.getDataFile() + " for build " + this.getOwner().getNumber());
            result = newProject;
        }
        catch (IOException exception) {
            LOGGER.log(Level.WARNING, "Failed to load " + this.getDataFile(), exception);
            result = new JavaProject();
        }
        this.project = new WeakReference<JavaProject>(result);
        return result;
    }

    public Collection<FileAnnotation> getNewWarnings() {
        if (this.newWarnings == null) {
            return this.loadNewWarnings();
        }
        Collection result = (Collection)this.newWarnings.get();
        if (result == null) {
            return this.loadNewWarnings();
        }
        return result;
    }

    private Collection<FileAnnotation> loadNewWarnings() {
        Collection difference = this.getProject().getAnnotations();
        if (this.hasPreviousResult()) {
            difference = AnnotationDifferencer.getNewAnnotations((Collection)difference, (Collection)this.getPreviousResult().getAnnotations());
        }
        this.newWarnings = new WeakReference<Collection>(difference);
        return difference;
    }

    public Collection<FileAnnotation> getFixedWarnings() {
        if (this.fixedWarnings == null) {
            return this.loadFixedWarnings();
        }
        Collection result = (Collection)this.fixedWarnings.get();
        if (result == null) {
            return this.loadFixedWarnings();
        }
        return result;
    }

    private Collection<FileAnnotation> loadFixedWarnings() {
        Collection<Object> difference = this.hasPreviousResult() ? AnnotationDifferencer.getFixedAnnotations((Collection)this.getProject().getAnnotations(), (Collection)this.getPreviousResult().getAnnotations()) : Collections.emptyList();
        this.fixedWarnings = new WeakReference(difference);
        return difference;
    }

    public boolean hasPreviousResult() {
        ResultAction action = (ResultAction)this.getOwner().getAction(this.getResultActionType());
        return action != null && action.hasPreviousResultAction();
    }

    public JavaProject getPreviousResult() {
        ResultAction action = (ResultAction)this.getOwner().getAction(this.getResultActionType());
        if (action != null && action.hasPreviousResultAction()) {
            return action.getPreviousResultAction().getResult().getProject();
        }
        return null;
    }

    protected abstract Class<? extends ResultAction<? extends BuildResult>> getResultActionType();

    public Object getDynamic(String link, StaplerRequest request, StaplerResponse response) {
        return DetailBuilder.create().createTrendDetails(link, this.getOwner(), this.getContainer(), this.getFixedWarnings(), this.getNewWarnings(), (Collection)this.getErrors(), this.getDefaultEncoding(), this.getDisplayName());
    }

    public Priority[] getPriorities() {
        return Priority.values();
    }

    public Collection<FileAnnotation> getAnnotations(String priority) {
        return this.getContainer().getAnnotations(priority);
    }

    public int getNumberOfAnnotations(String priority) {
        return this.getNumberOfAnnotations(Priority.fromString((String)priority));
    }

    public AnnotationContainer getContainer() {
        return this.getProject();
    }
}

