/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.tasks.util;

import hudson.plugins.tasks.util.Messages;
import hudson.plugins.tasks.util.SingleFieldValidator;
import java.io.IOException;
import javax.servlet.ServletException;
import org.apache.commons.lang.StringUtils;
import org.kohsuke.stapler.StaplerRequest;
import org.kohsuke.stapler.StaplerResponse;

public class TrendReportHeightValidator
extends SingleFieldValidator {
    private static final int HEIGHT = 200;
    private static final int MINIMUM_HEIGHT = 50;

    public TrendReportHeightValidator(StaplerRequest request, StaplerResponse response) {
        super(request, response);
    }

    public static int defaultHeight(String height) {
        int actualHeight = 200;
        if (!StringUtils.isEmpty((String)height)) {
            try {
                actualHeight = Math.max(50, Integer.valueOf(height));
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return actualHeight;
    }

    public void check(String value) throws IOException, ServletException {
        if (!StringUtils.isEmpty((String)value)) {
            try {
                int integer = Integer.valueOf(value);
                if (integer < 50) {
                    this.error(Messages.FieldValidator_Error_TrendHeight(50));
                    return;
                }
            }
            catch (NumberFormatException exception) {
                this.error(Messages.FieldValidator_Error_TrendHeight(50));
                return;
            }
        }
    }
}

