/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.tasks;

import hudson.plugins.tasks.util.model.AnnotationContainer;
import hudson.plugins.tasks.util.model.Priority;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import org.apache.commons.lang.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TaskTagsHandler
implements Serializable {
    private static final long serialVersionUID = 4156585047399976629L;
    private final String high;
    private final String normal;
    private final String low;
    private final AnnotationContainer provider;

    public TaskTagsHandler(String high, String normal, String low, AnnotationContainer provider) {
        this.high = high;
        this.normal = normal;
        this.low = low;
        this.provider = provider;
    }

    public Priority[] getPriorities() {
        ArrayList<Priority> actualPriorities = new ArrayList<Priority>();
        for (String priority : this.getAvailablePriorities()) {
            if (this.provider.getNumberOfAnnotations(priority) <= 0) continue;
            actualPriorities.add(Priority.fromString(priority));
        }
        return actualPriorities.toArray(new Priority[actualPriorities.size()]);
    }

    public Collection<String> getAvailablePriorities() {
        ArrayList<String> priorities = new ArrayList<String>();
        if (StringUtils.isNotEmpty((String)this.high)) {
            priorities.add(StringUtils.capitalize((String)StringUtils.lowerCase((String)Priority.HIGH.name())));
        }
        if (StringUtils.isNotEmpty((String)this.normal)) {
            priorities.add(StringUtils.capitalize((String)StringUtils.lowerCase((String)Priority.NORMAL.name())));
        }
        if (StringUtils.isNotEmpty((String)this.low)) {
            priorities.add(StringUtils.capitalize((String)StringUtils.lowerCase((String)Priority.LOW.name())));
        }
        return priorities;
    }

    public final String getTags(String priority) {
        return this.getTags(Priority.fromString(priority));
    }

    public final String getTags(Priority priority) {
        if (priority == Priority.HIGH) {
            return this.high;
        }
        if (priority == Priority.NORMAL) {
            return this.normal;
        }
        return this.low;
    }
}

